rule win_krbanker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.krbanker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.krbanker"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 895500 8b4104 894504 8b5108 895508 8b410c }
            // n = 6, score = 400
            //   895500               | mov                 dword ptr [ebp], edx
            //   8b4104               | mov                 eax, dword ptr [ecx + 4]
            //   894504               | mov                 dword ptr [ebp + 4], eax
            //   8b5108               | mov                 edx, dword ptr [ecx + 8]
            //   895508               | mov                 dword ptr [ebp + 8], edx
            //   8b410c               | mov                 eax, dword ptr [ecx + 0xc]

        $sequence_1 = { 6a00 6a00 6801030080 6a00 6802000000 6805000080 }
            // n = 6, score = 400
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6801030080           | push                0x80000301
            //   6a00                 | push                0
            //   6802000000           | push                2
            //   6805000080           | push                0x80000005

        $sequence_2 = { 23d0 8954244c eb08 c744244cffffffff 8d4c2424 }
            // n = 5, score = 400
            //   23d0                 | and                 edx, eax
            //   8954244c             | mov                 dword ptr [esp + 0x4c], edx
            //   eb08                 | jmp                 0xa
            //   c744244cffffffff     | mov                 dword ptr [esp + 0x4c], 0xffffffff
            //   8d4c2424             | lea                 ecx, [esp + 0x24]

        $sequence_3 = { bb40010000 e8???????? 83c410 8945d0 ff75d0 ff75d4 }
            // n = 6, score = 400
            //   bb40010000           | mov                 ebx, 0x140
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   8945d0               | mov                 dword ptr [ebp - 0x30], eax
            //   ff75d0               | push                dword ptr [ebp - 0x30]
            //   ff75d4               | push                dword ptr [ebp - 0x2c]

        $sequence_4 = { 8955e0 8d55d4 52 6a01 50 51 }
            // n = 6, score = 400
            //   8955e0               | mov                 dword ptr [ebp - 0x20], edx
            //   8d55d4               | lea                 edx, [ebp - 0x2c]
            //   52                   | push                edx
            //   6a01                 | push                1
            //   50                   | push                eax
            //   51                   | push                ecx

        $sequence_5 = { e8???????? 47 4b 3bdd 0f8d5bffffff eb02 8bde }
            // n = 7, score = 400
            //   e8????????           |                     
            //   47                   | inc                 edi
            //   4b                   | dec                 ebx
            //   3bdd                 | cmp                 ebx, ebp
            //   0f8d5bffffff         | jge                 0xffffff61
            //   eb02                 | jmp                 4
            //   8bde                 | mov                 ebx, esi

        $sequence_6 = { 75a4 dd442410 e8???????? 8ad8 }
            // n = 4, score = 400
            //   75a4                 | jne                 0xffffffa6
            //   dd442410             | fld                 qword ptr [esp + 0x10]
            //   e8????????           |                     
            //   8ad8                 | mov                 bl, al

        $sequence_7 = { c3 8b4c2420 8b542404 8d442408 50 51 }
            // n = 6, score = 400
            //   c3                   | ret                 
            //   8b4c2420             | mov                 ecx, dword ptr [esp + 0x20]
            //   8b542404             | mov                 edx, dword ptr [esp + 4]
            //   8d442408             | lea                 eax, [esp + 8]
            //   50                   | push                eax
            //   51                   | push                ecx

        $sequence_8 = { 50 8b5dec 8b1b 85db 7409 }
            // n = 5, score = 400
            //   50                   | push                eax
            //   8b5dec               | mov                 ebx, dword ptr [ebp - 0x14]
            //   8b1b                 | mov                 ebx, dword ptr [ebx]
            //   85db                 | test                ebx, ebx
            //   7409                 | je                  0xb

        $sequence_9 = { 0faffa 46 3bf0 76cf }
            // n = 4, score = 400
            //   0faffa               | imul                edi, edx
            //   46                   | inc                 esi
            //   3bf0                 | cmp                 esi, eax
            //   76cf                 | jbe                 0xffffffd1

    condition:
        7 of them and filesize < 1826816
}