rule win_ksl0t_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ksl0t."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ksl0t"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 44895c2440 897c2438 89542430 894c2428 89442420 488d15a8cb0000 }
            // n = 6, score = 200
            //   44895c2440           | dec                 eax
            //   897c2438             | lea                 ecx, [eax + edi - 0x22]
            //   89542430             | inc                 ecx
            //   894c2428             | mov                 ecx, 3
            //   89442420             | dec                 eax
            //   488d15a8cb0000       | sub                 edx, ecx

        $sequence_1 = { 4885c9 7405 e8???????? 488b8ba0000000 488d057f5c0000 483bc8 7405 }
            // n = 7, score = 200
            //   4885c9               | dec                 eax
            //   7405                 | lea                 ecx, [0xa767]
            //   e8????????           |                     
            //   488b8ba0000000       | dec                 eax
            //   488d057f5c0000       | lea                 edx, [0xaa56]
            //   483bc8               | dec                 esp
            //   7405                 | lea                 eax, [0x3d0f]

        $sequence_2 = { 48894c2408 4883ec18 c744240400000000 8b4c2404 8b442428 }
            // n = 5, score = 200
            //   48894c2408           | dec                 eax
            //   4883ec18             | test                ecx, ecx
            //   c744240400000000     | je                  0x1f
            //   8b4c2404             | dec                 eax
            //   8b442428             | mov                 ecx, dword ptr [ebx + 0xa0]

        $sequence_3 = { c68424e700000020 889c24e8000000 888424e9000000 c68424ea0000002d c68424eb00000002 888c24ec000000 c64424381a }
            // n = 7, score = 200
            //   c68424e700000020     | mov                 byte ptr [esp + 0xe7], 0x20
            //   889c24e8000000       | mov                 byte ptr [esp + 0xe8], bl
            //   888424e9000000       | mov                 byte ptr [esp + 0xe9], al
            //   c68424ea0000002d     | mov                 byte ptr [esp + 0xea], 0x2d
            //   c68424eb00000002     | mov                 byte ptr [esp + 0xeb], 2
            //   888c24ec000000       | mov                 byte ptr [esp + 0xec], cl
            //   c64424381a           | mov                 byte ptr [esp + 0x38], 0x1a

        $sequence_4 = { 83c008 898424f4080000 448b05???????? 49d1e0 }
            // n = 4, score = 200
            //   83c008               | dec                 eax
            //   898424f4080000       | mov                 eax, dword ptr [esp + 0x50]
            //   448b05????????       |                     
            //   49d1e0               | cmp                 dword ptr [eax], 0xa0

        $sequence_5 = { c644243331 c644243439 c644243539 884c2436 }
            // n = 4, score = 200
            //   c644243331           | mov                 byte ptr [esp + 0x33], 0x31
            //   c644243439           | mov                 byte ptr [esp + 0x34], 0x39
            //   c644243539           | mov                 byte ptr [esp + 0x35], 0x39
            //   884c2436             | mov                 byte ptr [esp + 0x36], cl

        $sequence_6 = { c684248600000067 88942487000000 c684248800000031 c684248900000039 c684248a00000039 }
            // n = 5, score = 200
            //   c684248600000067     | mov                 byte ptr [esp + 0x86], 0x67
            //   88942487000000       | mov                 byte ptr [esp + 0x87], dl
            //   c684248800000031     | mov                 byte ptr [esp + 0x88], 0x31
            //   c684248900000039     | mov                 byte ptr [esp + 0x89], 0x39
            //   c684248a00000039     | mov                 byte ptr [esp + 0x8a], 0x39

        $sequence_7 = { 488b442450 8138a0000000 7470 833d????????00 7528 }
            // n = 5, score = 200
            //   488b442450           | mov                 byte ptr [esp + 0xed], 0x31
            //   8138a0000000         | mov                 byte ptr [esp + 0xee], 0x20
            //   7470                 | mov                 byte ptr [esp + 0xef], 0x39
            //   833d????????00       |                     
            //   7528                 | mov                 byte ptr [esp + 0xf0], 0x30

        $sequence_8 = { 6800020000 57 8d95000d0000 52 }
            // n = 4, score = 200
            //   6800020000           | push                0x200
            //   57                   | push                edi
            //   8d95000d0000         | lea                 edx, [ebp + 0xd00]
            //   52                   | push                edx

        $sequence_9 = { 888c24fd000000 c68424b000000012 888424b1000000 889c24b2000000 c68424b300000019 c68424b400000034 }
            // n = 6, score = 200
            //   888c24fd000000       | mov                 byte ptr [esp + 0xfd], cl
            //   c68424b000000012     | mov                 byte ptr [esp + 0xb0], 0x12
            //   888424b1000000       | mov                 byte ptr [esp + 0xb1], al
            //   889c24b2000000       | mov                 byte ptr [esp + 0xb2], bl
            //   c68424b300000019     | mov                 byte ptr [esp + 0xb3], 0x19
            //   c68424b400000034     | mov                 byte ptr [esp + 0xb4], 0x34

        $sequence_10 = { 889c2451020000 c684245202000073 c68424530200006c c684245402000065 c68424550200006e c684245602000000 }
            // n = 6, score = 200
            //   889c2451020000       | mov                 byte ptr [esp + 0x251], bl
            //   c684245202000073     | mov                 byte ptr [esp + 0x252], 0x73
            //   c68424530200006c     | mov                 byte ptr [esp + 0x253], 0x6c
            //   c684245402000065     | mov                 byte ptr [esp + 0x254], 0x65
            //   c68424550200006e     | mov                 byte ptr [esp + 0x255], 0x6e
            //   c684245602000000     | mov                 byte ptr [esp + 0x256], 0

        $sequence_11 = { 488d0d67a70000 e8???????? 488d1556aa0000 4c8d050f3d0000 488d4c38de 41b903000000 482bd1 }
            // n = 7, score = 200
            //   488d0d67a70000       | je                  0x72
            //   e8????????           |                     
            //   488d1556aa0000       | jne                 0x2c
            //   4c8d050f3d0000       | add                 eax, 8
            //   488d4c38de           | mov                 dword ptr [esp + 0x8f4], eax
            //   41b903000000         | dec                 ecx
            //   482bd1               | shl                 eax, 1

        $sequence_12 = { c68424eb00000018 c68424ec0000003a c68424ed00000031 c68424ee00000020 c68424ef00000039 c68424f000000030 }
            // n = 6, score = 200
            //   c68424eb00000018     | movsx               eax, byte ptr [eax + ecx]
            //   c68424ec0000003a     | dec                 eax
            //   c68424ed00000031     | arpl                word ptr [esp + 0x20], ax
            //   c68424ee00000020     | xor                 edx, edx
            //   c68424ef00000039     | mov                 byte ptr [esp + 0xeb], 0x18
            //   c68424f000000030     | mov                 byte ptr [esp + 0xec], 0x3a

        $sequence_13 = { c68424f80200006c c68424f902000073 c68424fa02000074 c68424fb02000072 }
            // n = 4, score = 200
            //   c68424f80200006c     | mov                 byte ptr [esp + 0x2f8], 0x6c
            //   c68424f902000073     | mov                 byte ptr [esp + 0x2f9], 0x73
            //   c68424fa02000074     | mov                 byte ptr [esp + 0x2fa], 0x74
            //   c68424fb02000072     | mov                 byte ptr [esp + 0x2fb], 0x72

        $sequence_14 = { 390424 7d46 48630c24 488b442428 440fbe0408 4863442420 33d2 }
            // n = 7, score = 200
            //   390424               | cmp                 dword ptr [esp], eax
            //   7d46                 | jge                 0x48
            //   48630c24             | dec                 eax
            //   488b442428           | arpl                word ptr [esp], cx
            //   440fbe0408           | dec                 eax
            //   4863442420           | mov                 eax, dword ptr [esp + 0x28]
            //   33d2                 | inc                 esp

        $sequence_15 = { 33c9 66898d60060000 6806020000 51 8d9562060000 52 e8???????? }
            // n = 7, score = 200
            //   33c9                 | xor                 ecx, ecx
            //   66898d60060000       | mov                 word ptr [ebp + 0x660], cx
            //   6806020000           | push                0x206
            //   51                   | push                ecx
            //   8d9562060000         | lea                 edx, [ebp + 0x662]
            //   52                   | push                edx
            //   e8????????           |                     

    condition:
        7 of them and filesize < 196608
}