rule win_kurton_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.kurton."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kurton"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 57 e8???????? 68???????? e8???????? 83c404 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   57                   | push                edi
            //   e8????????           |                     
            //   68????????           |                     
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_1 = { 52 ff15???????? 8b44241c 3bc3 7407 50 }
            // n = 6, score = 100
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8b44241c             | mov                 eax, dword ptr [esp + 0x1c]
            //   3bc3                 | cmp                 eax, ebx
            //   7407                 | je                  9
            //   50                   | push                eax

        $sequence_2 = { 57 7355 8bc1 c1f805 8d3c85a05b0210 8bc1 }
            // n = 6, score = 100
            //   57                   | push                edi
            //   7355                 | jae                 0x57
            //   8bc1                 | mov                 eax, ecx
            //   c1f805               | sar                 eax, 5
            //   8d3c85a05b0210       | lea                 edi, [eax*4 + 0x10025ba0]
            //   8bc1                 | mov                 eax, ecx

        $sequence_3 = { 8d4c240c 50 51 6a1f 52 }
            // n = 5, score = 100
            //   8d4c240c             | lea                 ecx, [esp + 0xc]
            //   50                   | push                eax
            //   51                   | push                ecx
            //   6a1f                 | push                0x1f
            //   52                   | push                edx

        $sequence_4 = { 83e103 f3a4 8d4c240c e8???????? 8d4c2448 }
            // n = 5, score = 100
            //   83e103               | and                 ecx, 3
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   8d4c240c             | lea                 ecx, [esp + 0xc]
            //   e8????????           |                     
            //   8d4c2448             | lea                 ecx, [esp + 0x48]

        $sequence_5 = { 8bce e8???????? 84c0 0f84d4000000 8bce e8???????? 84c0 }
            // n = 7, score = 100
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   0f84d4000000         | je                  0xda
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   84c0                 | test                al, al

        $sequence_6 = { 0f8498feffff bf???????? 83c9ff 33c0 }
            // n = 4, score = 100
            //   0f8498feffff         | je                  0xfffffe9e
            //   bf????????           |                     
            //   83c9ff               | or                  ecx, 0xffffffff
            //   33c0                 | xor                 eax, eax

        $sequence_7 = { 33c0 c68414c400000000 8bac24c8020000 f2ae f7d1 }
            // n = 5, score = 100
            //   33c0                 | xor                 eax, eax
            //   c68414c400000000     | mov                 byte ptr [esp + edx + 0xc4], 0
            //   8bac24c8020000       | mov                 ebp, dword ptr [esp + 0x2c8]
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx

        $sequence_8 = { 3ac3 0f84d9000000 3cff 0f84d1000000 fec8 }
            // n = 5, score = 100
            //   3ac3                 | cmp                 al, bl
            //   0f84d9000000         | je                  0xdf
            //   3cff                 | cmp                 al, 0xff
            //   0f84d1000000         | je                  0xd7
            //   fec8                 | dec                 al

        $sequence_9 = { 57 55 8d5e10 8974241c 8bcb 8803 e8???????? }
            // n = 7, score = 100
            //   57                   | push                edi
            //   55                   | push                ebp
            //   8d5e10               | lea                 ebx, [esi + 0x10]
            //   8974241c             | mov                 dword ptr [esp + 0x1c], esi
            //   8bcb                 | mov                 ecx, ebx
            //   8803                 | mov                 byte ptr [ebx], al
            //   e8????????           |                     

    condition:
        7 of them and filesize < 344064
}