rule win_laturo_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.laturo."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.laturo"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 418bf0 4c8d0d83b80000 8bda 4c8d0572b80000 488bf9 488d1570b80000 }
            // n = 6, score = 200
            //   418bf0               | je                  0x48
            //   4c8d0d83b80000       | and                 eax, 0xf0
            //   8bda                 | cmp                 eax, 0x80
            //   4c8d0572b80000       | jne                 0x12c
            //   488bf9               | movzx               eax, byte ptr [esp + 0x50]
            //   488d1570b80000       | dec                 eax

        $sequence_1 = { 88442438 807c243801 7413 807c243802 743a }
            // n = 5, score = 200
            //   88442438             | mov                 byte ptr [esp + 0x70], dh
            //   807c243801           | jmp                 0x24
            //   7413                 | dec                 eax
            //   807c243802           | lea                 edi, [0x10a72]
            //   743a                 | jmp                 0x24

        $sequence_2 = { 57 4883ec78 c744242000000000 e8???????? 48833d????????00 0f84fb010000 488b8c2490000000 }
            // n = 7, score = 200
            //   57                   | push                edi
            //   4883ec78             | dec                 eax
            //   c744242000000000     | sub                 esp, 0x78
            //   e8????????           |                     
            //   48833d????????00     |                     
            //   0f84fb010000         | mov                 dword ptr [esp + 0x20], 0
            //   488b8c2490000000     | je                  0x201

        $sequence_3 = { 4889442410 837c244c40 750d 0fb60424 88442403 }
            // n = 5, score = 200
            //   4889442410           | mov                 ecx, dword ptr [esp + 0x30]
            //   837c244c40           | dec                 eax
            //   750d                 | add                 ecx, eax
            //   0fb60424             | dec                 eax
            //   88442403             | mov                 eax, ecx

        $sequence_4 = { 3b442450 740a 8b442420 89442424 }
            // n = 4, score = 200
            //   3b442450             | cmp                 eax, dword ptr [esp + 0x50]
            //   740a                 | je                  0xc
            //   8b442420             | mov                 eax, dword ptr [esp + 0x20]
            //   89442424             | mov                 dword ptr [esp + 0x24], eax

        $sequence_5 = { 4883ec38 488b442440 48833800 747b c744242000000000 eb0a }
            // n = 6, score = 200
            //   4883ec38             | dec                 eax
            //   488b442440           | mov                 ecx, dword ptr [esp + 0x90]
            //   48833800             | dec                 eax
            //   747b                 | sub                 esp, 0x38
            //   c744242000000000     | dec                 eax
            //   eb0a                 | mov                 eax, dword ptr [esp + 0x40]

        $sequence_6 = { 25f0000000 3d80000000 0f8521010000 0fb6442450 488b4c2430 4803c8 488bc1 }
            // n = 7, score = 200
            //   25f0000000           | dec                 eax
            //   3d80000000           | lea                 edi, [0x10a61]
            //   0f8521010000         | jmp                 0x24
            //   0fb6442450           | mov                 byte ptr [esp + 0x38], al
            //   488b4c2430           | cmp                 byte ptr [esp + 0x38], 1
            //   4803c8               | je                  0x1a
            //   488bc1               | cmp                 byte ptr [esp + 0x38], 2

        $sequence_7 = { 4488742470 eb22 488d3d720a0100 eb19 488d3d610a0100 eb10 }
            // n = 6, score = 200
            //   4488742470           | dec                 eax
            //   eb22                 | cmp                 dword ptr [eax], 0
            //   488d3d720a0100       | je                  0x86
            //   eb19                 | mov                 dword ptr [esp + 0x20], 0
            //   488d3d610a0100       | jmp                 0x14
            //   eb10                 | inc                 esp

        $sequence_8 = { eb3f f6c201 740d 8b0e 8d41fb 3985e0fdffff 7430 }
            // n = 7, score = 100
            //   eb3f                 | jne                 0x14
            //   f6c201               | movzx               eax, byte ptr [esp]
            //   740d                 | mov                 byte ptr [esp + 3], al
            //   8b0e                 | je                  4
            //   8d41fb               | jmp                 0x24
            //   3985e0fdffff         | movzx               eax, byte ptr [esp + 1]
            //   7430                 | and                 eax, 9

        $sequence_9 = { 2502ffffff eb0d 8b45f4 807dfa05 0fb6c0 }
            // n = 5, score = 100
            //   2502ffffff           | lea                 ecx, [0xb883]
            //   eb0d                 | mov                 ebx, edx
            //   8b45f4               | dec                 esp
            //   807dfa05             | lea                 eax, [0xb872]
            //   0fb6c0               | dec                 eax

        $sequence_10 = { 8a4dff d3e0 84c0 7907 }
            // n = 4, score = 100
            //   8a4dff               | sub                 bl, byte ptr [ebp - 0x28]
            //   d3e0                 | mov                 byte ptr [edx], bl
            //   84c0                 | cmp                 bl, 0xf
            //   7907                 | jbe                 0x1f

        $sequence_11 = { c745d500000000 66c745c40f80 c745c600000000 c645ff00 897de4 }
            // n = 5, score = 100
            //   c745d500000000       | test                eax, eax
            //   66c745c40f80         | je                  0x10
            //   c745c600000000       | jmp                 0x2a
            //   c645ff00             | inc                 ebx
            //   897de4               | mov                 byte ptr [edx + 0x10], al

        $sequence_12 = { c645f404 eb2b c645f401 eb25 f6c110 7410 }
            // n = 6, score = 100
            //   c645f404             | add                 ecx, eax
            //   eb2b                 | dec                 eax
            //   c645f401             | mov                 eax, ecx
            //   eb25                 | inc                 ecx
            //   f6c110               | mov                 esi, eax
            //   7410                 | dec                 esp

        $sequence_13 = { 51 0f95c0 6a40 8d044505000000 50 53 }
            // n = 6, score = 100
            //   51                   | mov                 edi, ecx
            //   0f95c0               | dec                 eax
            //   6a40                 | lea                 edx, [0xb870]
            //   8d044505000000       | dec                 eax
            //   50                   | mov                 dword ptr [esp + 0x10], eax
            //   53                   | cmp                 dword ptr [esp + 0x4c], 0x40

        $sequence_14 = { 43 884210 2a5dd8 881a 80fb0f 7615 814a1800500000 }
            // n = 7, score = 100
            //   43                   | and                 eax, 0xf0
            //   884210               | cmp                 eax, 0x80
            //   2a5dd8               | jne                 0x127
            //   881a                 | movzx               eax, byte ptr [esp + 0x50]
            //   80fb0f               | dec                 eax
            //   7615                 | mov                 ecx, dword ptr [esp + 0x30]
            //   814a1800500000       | dec                 eax

        $sequence_15 = { 68???????? 897df8 ff15???????? 85c0 742a 8b3d???????? 83fe20 }
            // n = 7, score = 100
            //   68????????           |                     
            //   897df8               | or                  dword ptr [edx + 0x18], 0x5000
            //   ff15????????         |                     
            //   85c0                 | mov                 byte ptr [ebp - 0xc], 4
            //   742a                 | jmp                 0x2d
            //   8b3d????????         |                     
            //   83fe20               | mov                 byte ptr [ebp - 0xc], 1

    condition:
        7 of them and filesize < 253952
}