rule win_lazarloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.lazarloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lazarloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 48894de8 488945f0 488d15a0bd0000 b805000000 894520 894528 }
            // n = 6, score = 100
            //   48894de8             | dec                 eax
            //   488945f0             | cmp                 dword ptr [ecx + 0x138], edi
            //   488d15a0bd0000       | jne                 0x2a2
            //   b805000000           | dec                 eax
            //   894520               | lea                 eax, [0xdc03]
            //   894528               | dec                 edx

        $sequence_1 = { 488bd7 4c8d05fecd0000 83e23f 488bcf }
            // n = 4, score = 100
            //   488bd7               | jmp                 0x20
            //   4c8d05fecd0000       | dec                 eax
            //   83e23f               | test                eax, eax
            //   488bcf               | jne                 0x2a

        $sequence_2 = { 33c0 b906020000 f3aa 33c0 66898424d0060000 488d8424d2060000 488bf8 }
            // n = 7, score = 100
            //   33c0                 | mov                 ecx, dword ptr [esp + 0x60]
            //   b906020000           | test                eax, eax
            //   f3aa                 | je                  0x75
            //   33c0                 | dec                 eax
            //   66898424d0060000     | mov                 ecx, dword ptr [esp + 0x38]
            //   488d8424d2060000     | dec                 eax
            //   488bf8               | lea                 edx, [0xd19e]

        $sequence_3 = { 488bc2 e9???????? 493bec 0f84be000000 8b7500 33c0 f04d0fb1bcf120ba0100 }
            // n = 7, score = 100
            //   488bc2               | dec                 eax
            //   e9????????           |                     
            //   493bec               | mov                 dword ptr [esp + eax + 0x20], ecx
            //   0f84be000000         | mov                 eax, 8
            //   8b7500               | dec                 eax
            //   33c0                 | imul                eax, eax, 1
            //   f04d0fb1bcf120ba0100     | dec    eax

        $sequence_4 = { 4889842490000000 488b442470 0fb700 6689442432 488b442458 0fb74c2432 }
            // n = 6, score = 100
            //   4889842490000000     | mov                 eax, 1
            //   488b442470           | dec                 eax
            //   0fb700               | imul                eax, eax, 0
            //   6689442432           | dec                 eax
            //   488b442458           | mov                 ecx, dword ptr [esp + 0x58]
            //   0fb74c2432           | mov                 byte ptr [ecx + eax], 0x4d

        $sequence_5 = { 4885c9 7430 53 4883ec20 488d0563810000 }
            // n = 5, score = 100
            //   4885c9               | dec                 eax
            //   7430                 | lea                 edx, [esp + 0x2b0]
            //   53                   | xor                 ecx, ecx
            //   4883ec20             | inc                 ebp
            //   488d0563810000       | xor                 esi, esi

        $sequence_6 = { eb19 488d1dec1e0100 eb10 488d1df31e0100 eb07 488d1dd21e0100 }
            // n = 6, score = 100
            //   eb19                 | ret                 
            //   488d1dec1e0100       | inc                 eax
            //   eb10                 | push                edi
            //   488d1df31e0100       | dec                 eax
            //   eb07                 | sub                 esp, 0x20
            //   488d1dd21e0100       | dec                 eax

        $sequence_7 = { 4883ec20 e8???????? 488b05???????? 488d1da7710100 }
            // n = 4, score = 100
            //   4883ec20             | jmp                 0x257
            //   e8????????           |                     
            //   488b05????????       |                     
            //   488d1da7710100       | dec                 ebp

        $sequence_8 = { e8???????? 89442460 33c9 e8???????? }
            // n = 4, score = 100
            //   e8????????           |                     
            //   89442460             | lea                 ecx, [0x12b7e]
            //   33c9                 | dec                 eax
            //   e8????????           |                     

        $sequence_9 = { 85c0 750d 488bcb e8???????? e9???????? 4c8d2557230100 }
            // n = 6, score = 100
            //   85c0                 | mov                 dword ptr [edi + 4], ebp
            //   750d                 | jne                 0x27c
            //   488bcb               | dec                 eax
            //   e8????????           |                     
            //   e9????????           |                     
            //   4c8d2557230100       | lea                 ecx, [0x19f00]

    condition:
        7 of them and filesize < 364544
}