rule win_lcpdot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.lcpdot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lcpdot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e9???????? c705????????01000000 e8???????? 83f801 }
            // n = 4, score = 200
            //   e9????????           |                     
            //   c705????????01000000     |     
            //   e8????????           |                     
            //   83f801               | cmp                 eax, 1

        $sequence_1 = { 418bdc 4c89642438 4489642430 488d442430 }
            // n = 4, score = 100
            //   418bdc               | inc                 ecx
            //   4c89642438           | mov                 ebx, esp
            //   4489642430           | dec                 esp
            //   488d442430           | mov                 dword ptr [esp + 0x38], esp

        $sequence_2 = { 8bf1 889d14fcffff e8???????? 8d4620 83c40c 8d5002 }
            // n = 6, score = 100
            //   8bf1                 | mov                 eax, 0x3e8
            //   889d14fcffff         | cmp                 eax, 1
            //   e8????????           |                     
            //   8d4620               | push                edx
            //   83c40c               | mov                 eax, dword ptr [ebp - 0x1010]
            //   8d5002               | mov                 ecx, dword ptr [ebp - 0x1018]

        $sequence_3 = { c78560fbffff4b4c6763 c78564fbffff66975c5f c78568fbffff8d676a9b c7856cfbffff5254774f c78570fbffff51724647 c78574fbffff5d9293ab }
            // n = 6, score = 100
            //   c78560fbffff4b4c6763     | mov    edx, dword ptr [esi + 4]
            //   c78564fbffff66975c5f     | push    0
            //   c78568fbffff8d676a9b     | push    0
            //   c7856cfbffff5254774f     | mov    dword ptr [ebp - 0x38], esi
            //   c78570fbffff51724647     | mov    dword ptr [ebp - 0x24], 0x416338
            //   c78574fbffff5d9293ab     | push    0

        $sequence_4 = { 742b 488d153c300100 eb15 48ffc9 741d 448b4338 }
            // n = 6, score = 100
            //   742b                 | inc                 esp
            //   488d153c300100       | mov                 ebx, edx
            //   eb15                 | inc                 ecx
            //   48ffc9               | sar                 ebx, 5
            //   741d                 | mov                 dword ptr [ebp - 0x6c], 0xd8927ec1
            //   448b4338             | mov                 dword ptr [ebp - 0x68], 0x9fd7b6a0

        $sequence_5 = { 52 ff15???????? 8b85f0efffff 8b8de8efffff 8b5604 6a00 6a00 }
            // n = 7, score = 100
            //   52                   | inc                 ebp
            //   ff15????????         |                     
            //   8b85f0efffff         | test                eax, eax
            //   8b8de8efffff         | je                  0x1e
            //   8b5604               | dec                 eax
            //   6a00                 | lea                 edx, [0x13837]
            //   6a00                 | dec                 eax

        $sequence_6 = { e8???????? 85c0 745f 8b8db4fbffff 85c9 7e23 8b85b8fbffff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   85c0                 | dec                 esp
            //   745f                 | lea                 ecx, [0xffff90c9]
            //   8b8db4fbffff         | inc                 ebp
            //   85c9                 | mov                 ah, byte ptr [eax]
            //   7e23                 | inc                 ebp
            //   8b85b8fbffff         | test                ah, ah

        $sequence_7 = { ff15???????? 85c0 7468 33d2 68fe010000 }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   85c0                 | push                esi
            //   7468                 | test                eax, eax
            //   33d2                 | je                  0x63
            //   68fe010000           | mov                 ecx, dword ptr [ebp - 0x44c]

        $sequence_8 = { 741e 448b4638 4585c0 7415 488d1537380100 488d8c2440020000 }
            // n = 6, score = 100
            //   741e                 | mov                 dword ptr [ebp - 0x64], 0xcbb8e6b6
            //   448b4638             | mov                 dword ptr [ebp - 0x60], 0xd0cab6e5
            //   4585c0               | mov                 dword ptr [ebp - 0x5c], 0xf5f5ded0
            //   7415                 | mov                 dword ptr [ebp - 0x58], 0xf7f2f2fa
            //   488d1537380100       | je                  0x2d
            //   488d8c2440020000     | dec                 eax

        $sequence_9 = { 8b542460 41bb00020000 4c8d0dc990ffff 458a20 4584e4 }
            // n = 5, score = 100
            //   8b542460             | lea                 edx, [0x1303c]
            //   41bb00020000         | jmp                 0x17
            //   4c8d0dc990ffff       | dec                 eax
            //   458a20               | dec                 ecx
            //   4584e4               | je                  0x24

        $sequence_10 = { 8975c8 c745dc38634100 ff15???????? 6a00 56 }
            // n = 5, score = 100
            //   8975c8               | lea                 ecx, [esp + 0x240]
            //   c745dc38634100       | mov                 edx, dword ptr [esp + 0x60]
            //   ff15????????         |                     
            //   6a00                 | inc                 ecx
            //   56                   | mov                 ebx, 0x200

        $sequence_11 = { e9???????? 488bd3 b940000000 4889ac24a8080000 }
            // n = 4, score = 100
            //   e9????????           |                     
            //   488bd3               | inc                 esp
            //   b940000000           | mov                 dword ptr [esp + 0x30], esp
            //   4889ac24a8080000     | dec                 eax

        $sequence_12 = { c74594c17e92d8 c74598a0b6d79f c7459cb6e6b8cb c745a0e5b6cad0 c745a4d0def5f5 c745a8faf2f2f7 }
            // n = 6, score = 100
            //   c74594c17e92d8       | dec                 eax
            //   c74598a0b6d79f       | mov                 dword ptr [esp + 0x8a8], ebp
            //   c7459cb6e6b8cb       | inc                 esi
            //   c745a0e5b6cad0       | lea                 ebp, [esi*4]
            //   c745a4d0def5f5       | inc                 ecx
            //   c745a8faf2f2f7       | imul                ebp

        $sequence_13 = { 468d2cb500000000 41f7ed 448bda 41c1fb05 }
            // n = 4, score = 100
            //   468d2cb500000000     | lea                 eax, [esp + 0x30]
            //   41f7ed               | dec                 eax
            //   448bda               | mov                 edx, ebx
            //   41c1fb05             | mov                 ecx, 0x40

        $sequence_14 = { 52 8d041f 50 e8???????? 8b861c080000 83c418 03c7 }
            // n = 7, score = 100
            //   52                   | mov                 edx, 0x1f4
            //   8d041f               | dec                 eax
            //   50                   | lea                 ecx, [esp + 0x20]
            //   e8????????           |                     
            //   8b861c080000         | dec                 eax
            //   83c418               | lea                 edx, [esp + 0x410]
            //   03c7                 | inc                 ecx

    condition:
        7 of them and filesize < 257024
}