rule win_ldr4_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ldr4."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ldr4"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 56 8d45b4 50 53 33f6 56 }
            // n = 6, score = 100
            //   56                   | push                esi
            //   8d45b4               | lea                 eax, [ebp - 0x4c]
            //   50                   | push                eax
            //   53                   | push                ebx
            //   33f6                 | xor                 esi, esi
            //   56                   | push                esi

        $sequence_1 = { 8b4008 8945f4 a1???????? 53 35fc28b0ec 56 50 }
            // n = 7, score = 100
            //   8b4008               | mov                 eax, dword ptr [eax + 8]
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   a1????????           |                     
            //   53                   | push                ebx
            //   35fc28b0ec           | xor                 eax, 0xecb028fc
            //   56                   | push                esi
            //   50                   | push                eax

        $sequence_2 = { c745f40c000000 c745fc01000000 895df8 ffd7 85c0 7508 }
            // n = 6, score = 100
            //   c745f40c000000       | mov                 dword ptr [ebp - 0xc], 0xc
            //   c745fc01000000       | mov                 dword ptr [ebp - 4], 1
            //   895df8               | mov                 dword ptr [ebp - 8], ebx
            //   ffd7                 | call                edi
            //   85c0                 | test                eax, eax
            //   7508                 | jne                 0xa

        $sequence_3 = { 53 56 57 8bf8 a1???????? 8b5808 8b07 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   8bf8                 | mov                 edi, eax
            //   a1????????           |                     
            //   8b5808               | mov                 ebx, dword ptr [eax + 8]
            //   8b07                 | mov                 eax, dword ptr [edi]

        $sequence_4 = { a1???????? 8b4008 89442404 85f6 0f84c9000000 8b4610 85c0 }
            // n = 7, score = 100
            //   a1????????           |                     
            //   8b4008               | mov                 eax, dword ptr [eax + 8]
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   85f6                 | test                esi, esi
            //   0f84c9000000         | je                  0xcf
            //   8b4610               | mov                 eax, dword ptr [esi + 0x10]
            //   85c0                 | test                eax, eax

        $sequence_5 = { 8b4008 57 8b3d???????? 6a40 8945f8 8d45b8 }
            // n = 6, score = 100
            //   8b4008               | mov                 eax, dword ptr [eax + 8]
            //   57                   | push                edi
            //   8b3d????????         |                     
            //   6a40                 | push                0x40
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   8d45b8               | lea                 eax, [ebp - 0x48]

        $sequence_6 = { ff15???????? 8bf0 85f6 750c 57 ff15???????? 6a08 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   750c                 | jne                 0xe
            //   57                   | push                edi
            //   ff15????????         |                     
            //   6a08                 | push                8

        $sequence_7 = { 3bc6 743c 56 56 ff75f4 }
            // n = 5, score = 100
            //   3bc6                 | cmp                 eax, esi
            //   743c                 | je                  0x3e
            //   56                   | push                esi
            //   56                   | push                esi
            //   ff75f4               | push                dword ptr [ebp - 0xc]

        $sequence_8 = { ff15???????? 8d4608 50 e8???????? 837e0400 7414 6aff }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8d4608               | lea                 eax, [esi + 8]
            //   50                   | push                eax
            //   e8????????           |                     
            //   837e0400             | cmp                 dword ptr [esi + 4], 0
            //   7414                 | je                  0x16
            //   6aff                 | push                -1

        $sequence_9 = { 35fc28b0ec 56 50 8b4508 8b402c e8???????? 85c0 }
            // n = 7, score = 100
            //   35fc28b0ec           | xor                 eax, 0xecb028fc
            //   56                   | push                esi
            //   50                   | push                eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b402c               | mov                 eax, dword ptr [eax + 0x2c]
            //   e8????????           |                     
            //   85c0                 | test                eax, eax

    condition:
        7 of them and filesize < 117760
}