rule win_leash_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.leash."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.leash"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 83c408 85c0 744f 8b0e 53 83c10c }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax
            //   744f                 | je                  0x51
            //   8b0e                 | mov                 ecx, dword ptr [esi]
            //   53                   | push                ebx
            //   83c10c               | add                 ecx, 0xc

        $sequence_1 = { e8???????? 8bf8 8d8548feffff 6a0a 50 6a00 56 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   8d8548feffff         | lea                 eax, [ebp - 0x1b8]
            //   6a0a                 | push                0xa
            //   50                   | push                eax
            //   6a00                 | push                0
            //   56                   | push                esi

        $sequence_2 = { 8b5d08 8d55cc 50 52 8d8bff000000 c645fc02 }
            // n = 6, score = 200
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]
            //   8d55cc               | lea                 edx, [ebp - 0x34]
            //   50                   | push                eax
            //   52                   | push                edx
            //   8d8bff000000         | lea                 ecx, [ebx + 0xff]
            //   c645fc02             | mov                 byte ptr [ebp - 4], 2

        $sequence_3 = { 83c41c 83f8ff 0f8482010000 85c0 }
            // n = 4, score = 200
            //   83c41c               | add                 esp, 0x1c
            //   83f8ff               | cmp                 eax, -1
            //   0f8482010000         | je                  0x188
            //   85c0                 | test                eax, eax

        $sequence_4 = { 83c41c f2ae f7d1 2bf9 8bd1 8bf7 8bfd }
            // n = 7, score = 200
            //   83c41c               | add                 esp, 0x1c
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   2bf9                 | sub                 edi, ecx
            //   8bd1                 | mov                 edx, ecx
            //   8bf7                 | mov                 esi, edi
            //   8bfd                 | mov                 edi, ebp

        $sequence_5 = { 8b7c242c 6800040000 8d8328380000 57 50 e8???????? 668b44243c }
            // n = 7, score = 200
            //   8b7c242c             | mov                 edi, dword ptr [esp + 0x2c]
            //   6800040000           | push                0x400
            //   8d8328380000         | lea                 eax, [ebx + 0x3828]
            //   57                   | push                edi
            //   50                   | push                eax
            //   e8????????           |                     
            //   668b44243c           | mov                 ax, word ptr [esp + 0x3c]

        $sequence_6 = { aa b9ff000000 33c0 8dbc2411040000 f3ab }
            // n = 5, score = 200
            //   aa                   | stosb               byte ptr es:[edi], al
            //   b9ff000000           | mov                 ecx, 0xff
            //   33c0                 | xor                 eax, eax
            //   8dbc2411040000       | lea                 edi, [esp + 0x411]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax

        $sequence_7 = { 8dbd5df9ffff 889d5cf9ffff f3ab 66ab aa b9ff000000 33c0 }
            // n = 7, score = 200
            //   8dbd5df9ffff         | lea                 edi, [ebp - 0x6a3]
            //   889d5cf9ffff         | mov                 byte ptr [ebp - 0x6a4], bl
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   aa                   | stosb               byte ptr es:[edi], al
            //   b9ff000000           | mov                 ecx, 0xff
            //   33c0                 | xor                 eax, eax

        $sequence_8 = { 68???????? e8???????? a1???????? 83c40c 8d95e4f7ffff 8d8819100000 51 }
            // n = 7, score = 200
            //   68????????           |                     
            //   e8????????           |                     
            //   a1????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d95e4f7ffff         | lea                 edx, [ebp - 0x81c]
            //   8d8819100000         | lea                 ecx, [eax + 0x1019]
            //   51                   | push                ecx

        $sequence_9 = { e9???????? 8d8424fc290000 8d8c24fc050000 50 51 e8???????? }
            // n = 6, score = 200
            //   e9????????           |                     
            //   8d8424fc290000       | lea                 eax, [esp + 0x29fc]
            //   8d8c24fc050000       | lea                 ecx, [esp + 0x5fc]
            //   50                   | push                eax
            //   51                   | push                ecx
            //   e8????????           |                     

    condition:
        7 of them and filesize < 761856
}