rule win_lechiket_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.lechiket."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lechiket"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 57 ff15???????? 3d02010000 7519 56 ff15???????? 53 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   ff15????????         |                     
            //   3d02010000           | cmp                 eax, 0x102
            //   7519                 | jne                 0x1b
            //   56                   | push                esi
            //   ff15????????         |                     
            //   53                   | push                ebx

        $sequence_1 = { 57 eb4b 8a16 80fac0 }
            // n = 4, score = 100
            //   57                   | push                edi
            //   eb4b                 | jmp                 0x4d
            //   8a16                 | mov                 dl, byte ptr [esi]
            //   80fac0               | cmp                 dl, 0xc0

        $sequence_2 = { 740f 47 3b7d0c 76d6 33c0 }
            // n = 5, score = 100
            //   740f                 | je                  0x11
            //   47                   | inc                 edi
            //   3b7d0c               | cmp                 edi, dword ptr [ebp + 0xc]
            //   76d6                 | jbe                 0xffffffd8
            //   33c0                 | xor                 eax, eax

        $sequence_3 = { 51 ff7518 8365fc00 ff7514 8d4510 }
            // n = 5, score = 100
            //   51                   | push                ecx
            //   ff7518               | push                dword ptr [ebp + 0x18]
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   8d4510               | lea                 eax, [ebp + 0x10]

        $sequence_4 = { c786????????1a000000 8a550b 8bcb ff15???????? 5f 5e }
            // n = 6, score = 100
            //   c786????????1a000000     |     
            //   8a550b               | mov                 dl, byte ptr [ebp + 0xb]
            //   8bcb                 | mov                 ecx, ebx
            //   ff15????????         |                     
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_5 = { ff750c e8???????? 85c0 0f84bdfdffff 8b4df8 8d7c0f01 8d480a }
            // n = 7, score = 100
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f84bdfdffff         | je                  0xfffffdc3
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   8d7c0f01             | lea                 edi, [edi + ecx + 1]
            //   8d480a               | lea                 ecx, [eax + 0xa]

        $sequence_6 = { 85d2 7505 b80d0000c0 85ff 5e 740c 85c0 }
            // n = 7, score = 100
            //   85d2                 | test                edx, edx
            //   7505                 | jne                 7
            //   b80d0000c0           | mov                 eax, 0xc000000d
            //   85ff                 | test                edi, edi
            //   5e                   | pop                 esi
            //   740c                 | je                  0xe
            //   85c0                 | test                eax, eax

        $sequence_7 = { e8???????? 84c0 7504 fec0 eb1c 53 8bce }
            // n = 7, score = 100
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   7504                 | jne                 6
            //   fec0                 | inc                 al
            //   eb1c                 | jmp                 0x1e
            //   53                   | push                ebx
            //   8bce                 | mov                 ecx, esi

        $sequence_8 = { 33f6 39750c 57 7613 ff15???????? 88843500ffffff 46 }
            // n = 7, score = 100
            //   33f6                 | xor                 esi, esi
            //   39750c               | cmp                 dword ptr [ebp + 0xc], esi
            //   57                   | push                edi
            //   7613                 | jbe                 0x15
            //   ff15????????         |                     
            //   88843500ffffff       | mov                 byte ptr [ebp + esi - 0x100], al
            //   46                   | inc                 esi

        $sequence_9 = { 8945f8 8d45d0 6808070000 50 }
            // n = 4, score = 100
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   8d45d0               | lea                 eax, [ebp - 0x30]
            //   6808070000           | push                0x708
            //   50                   | push                eax

    condition:
        7 of them and filesize < 331776
}