rule win_lemonduck_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.lemonduck."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lemonduck"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 8bc8 89834c010000 e8???????? 4863c8 48898b88000000 4883c420 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8bc8                 | dec                 eax
            //   89834c010000         | mov                 edx, edi
            //   e8????????           |                     
            //   4863c8               | dec                 ecx
            //   48898b88000000       | mov                 ecx, esi
            //   4883c420             | mov                 ecx, eax

        $sequence_1 = { eb0f 488bd3 488d0deb090a00 e8???????? 33c9 85c0 480f44cb }
            // n = 7, score = 100
            //   eb0f                 | inc                 ecx
            //   488bd3               | cmp                 edi, ebp
            //   488d0deb090a00       | jbe                 0x2ef
            //   e8????????           |                     
            //   33c9                 | dec                 eax
            //   85c0                 | mov                 esi, dword ptr [esp + 0x40]
            //   480f44cb             | jmp                 0x2c0

        $sequence_2 = { c1e808 0bc8 41c1e808 c1e218 4133ca 440bc2 41894f10 }
            // n = 7, score = 100
            //   c1e808               | xor                 edi, 0x243f6a88
            //   0bc8                 | shl                 edx, 8
            //   41c1e808             | movzx               eax, byte ptr [esi + 0x1e]
            //   c1e218               | inc                 esp
            //   4133ca               | xor                 ebx, ecx
            //   440bc2               | inc                 ecx
            //   41894f10             | shr                 eax, 0x18

        $sequence_3 = { ff15???????? 488bf8 4885c0 0f841f020000 33c0 f0480fb13d???????? 488bf0 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   488bf8               | mov                 ecx, ebx
            //   4885c0               | dec                 eax
            //   0f841f020000         | lea                 edx, [0x56c88]
            //   33c0                 | dec                 eax
            //   f0480fb13d????????     |     
            //   488bf0               | mov                 ecx, ebx

        $sequence_4 = { 7404 893b eb34 3bfe 7330 2bf7 488d14bd00000000 }
            // n = 7, score = 100
            //   7404                 | mov                 ecx, ebx
            //   893b                 | dec                 esp
            //   eb34                 | mov                 edi, dword ptr [ebx + 0x70]
            //   3bfe                 | inc                 ecx
            //   7330                 | mov                 dh, 1
            //   2bf7                 | test                eax, eax
            //   488d14bd00000000     | jae                 0x29e

        $sequence_5 = { e8???????? e9???????? 488b8e50010000 488d85e8000000 4c8d8dd0000000 4889442420 4c8d85e0000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   e9????????           |                     
            //   488b8e50010000       | dec                 esp
            //   488d85e8000000       | arpl                ax, cx
            //   4c8d8dd0000000       | xor                 edx, edx
            //   4889442420           | dec                 eax
            //   4c8d85e0000000       | mov                 ecx, edi

        $sequence_6 = { e8???????? 85c0 7419 41b80a000000 488d15eab90500 488bcb e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   85c0                 | je                  0x224
            //   7419                 | mov                 ecx, eax
            //   41b80a000000         | nop                 
            //   488d15eab90500       | movzx               ecx, byte ptr [edi + 0x1440]
            //   488bcb               | test                eax, eax
            //   e8????????           |                     

        $sequence_7 = { e8???????? e9???????? 664183780e03 0f85e0010000 488d1d8bee1500 4c8d3dacee1500 0f1f4000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   e9????????           |                     
            //   664183780e03         | dec                 eax
            //   0f85e0010000         | mov                 esi, dword ptr [ebp + 0x40]
            //   488d1d8bee1500       | dec                 esp
            //   4c8d3dacee1500       | lea                 ecx, [ebp - 0x10]
            //   0f1f4000             | dec                 eax

        $sequence_8 = { 75f7 8945c8 33c0 488945d8 488945e0 66448965e6 488b45e0 }
            // n = 7, score = 100
            //   75f7                 | dec                 eax
            //   8945c8               | test                ebx, ebx
            //   33c0                 | je                  0x6d
            //   488945d8             | dec                 eax
            //   488945e0             | cmp                 dword ptr [ebx + 0x10], 0
            //   66448965e6           | je                  0x64
            //   488b45e0             | dec                 eax

        $sequence_9 = { ff5018 f6d8 1bdb 83c302 b978000000 e8???????? 488bf8 }
            // n = 7, score = 100
            //   ff5018               | mov                 ecx, ebp
            //   f6d8                 | dec                 eax
            //   1bdb                 | mov                 ebp, dword ptr [esp + 0xa8]
            //   83c302               | mov                 edi, eax
            //   b978000000           | dec                 eax
            //   e8????????           |                     
            //   488bf8               | test                ebp, ebp

    condition:
        7 of them and filesize < 10011648
}