rule win_lethic_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.lethic."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lethic"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b550c 8955f8 8b45f8 034510 8945f4 }
            // n = 5, score = 1200
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   8955f8               | mov                 dword ptr [ebp - 8], edx
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   034510               | add                 eax, dword ptr [ebp + 0x10]
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax

        $sequence_1 = { c7823410000001000000 6a10 8b450c 50 8b4dfc 83c108 51 }
            // n = 7, score = 1200
            //   c7823410000001000000     | mov    dword ptr [edx + 0x1034], 1
            //   6a10                 | push                0x10
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   50                   | push                eax
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   83c108               | add                 ecx, 8
            //   51                   | push                ecx

        $sequence_2 = { 8945fc 8b4dfc 894df0 8b550c }
            // n = 4, score = 1200
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   894df0               | mov                 dword ptr [ebp - 0x10], ecx
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]

        $sequence_3 = { ffd1 33c0 eb42 6a10 }
            // n = 4, score = 1200
            //   ffd1                 | call                ecx
            //   33c0                 | xor                 eax, eax
            //   eb42                 | jmp                 0x44
            //   6a10                 | push                0x10

        $sequence_4 = { 8b08 890a 8b55fc 8b02 8945fc 8b4df4 51 }
            // n = 7, score = 1200
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   890a                 | mov                 dword ptr [edx], ecx
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   51                   | push                ecx

        $sequence_5 = { 8b55fc 83c208 52 8b45fc 8b4818 51 }
            // n = 6, score = 1200
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   83c208               | add                 edx, 8
            //   52                   | push                edx
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b4818               | mov                 ecx, dword ptr [eax + 0x18]
            //   51                   | push                ecx

        $sequence_6 = { 33c0 e9???????? 8b45fc 8b4d10 894804 8b55fc c7823410000001000000 }
            // n = 7, score = 1200
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   894804               | mov                 dword ptr [eax + 4], ecx
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   c7823410000001000000     | mov    dword ptr [edx + 0x1034], 1

        $sequence_7 = { 890a 8b55fc 8b02 8945fc 8b4df4 51 8b55f8 }
            // n = 7, score = 1200
            //   890a                 | mov                 dword ptr [edx], ecx
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   51                   | push                ecx
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]

        $sequence_8 = { 894df8 8b55fc 3b55f8 7411 8b45fc c60000 }
            // n = 6, score = 1200
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   3b55f8               | cmp                 edx, dword ptr [ebp - 8]
            //   7411                 | je                  0x13
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   c60000               | mov                 byte ptr [eax], 0

        $sequence_9 = { 8b55fc c7823410000001000000 6a10 8b450c 50 8b4dfc 83c108 }
            // n = 7, score = 1200
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   c7823410000001000000     | mov    dword ptr [edx + 0x1034], 1
            //   6a10                 | push                0x10
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   50                   | push                eax
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   83c108               | add                 ecx, 8

    condition:
        7 of them and filesize < 81920
}