rule win_lightlesscan_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.lightlesscan."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lightlesscan"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83fb02 0f8539020000 33c0 4585ed 0f84bb010000 448b442464 488945b0 }
            // n = 7, score = 100
            //   83fb02               | dec                 eax
            //   0f8539020000         | lea                 ecx, [ebp + 0x50]
            //   33c0                 | test                edi, edi
            //   4585ed               | jns                 0x57d
            //   0f84bb010000         | inc                 esp
            //   448b442464           | mov                 eax, edi
            //   488945b0             | nop                 

        $sequence_1 = { 4885db 745a 488d0dda770400 e8???????? 4c8d4c2450 458bc4 488bd6 }
            // n = 7, score = 100
            //   4885db               | dec                 eax
            //   745a                 | mov                 ecx, dword ptr [esp + 0x58]
            //   488d0dda770400       | call                eax
            //   e8????????           |                     
            //   4c8d4c2450           | dec                 esp
            //   458bc4               | mov                 ebx, dword ptr [esp + 0x78]
            //   488bd6               | dec                 ecx

        $sequence_2 = { 4c8d4c2478 4533c0 418d5001 488b4d28 ffd0 }
            // n = 5, score = 100
            //   4c8d4c2478           | dec                 esp
            //   4533c0               | inc                 ecx
            //   418d5001             | or                  esp, 0xffffffe0
            //   488b4d28             | inc                 esp
            //   ffd0                 | mov                 esp, eax

        $sequence_3 = { 8b442434 eb8c 85c0 0f858c060000 33db 4d8be7 8bfb }
            // n = 7, score = 100
            //   8b442434             | je                  0x5a3
            //   eb8c                 | inc                 ebx
            //   85c0                 | mov                 dword ptr [esp + 0x20], 4
            //   0f858c060000         | dec                 esp
            //   33db                 | lea                 eax, [esp + 0x58]
            //   4d8be7               | inc                 ecx
            //   8bfb                 | mov                 ecx, 0x10

        $sequence_4 = { e8???????? 488d4c2454 4c89642428 48894c2420 488b4c2458 4533c9 4533c0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488d4c2454           | mov                 dword ptr [esp + 0x20], esp
            //   4c89642428           | dec                 esp
            //   48894c2420           | mov                 eax, ebp
            //   488b4c2458           | dec                 eax
            //   4533c9               | mov                 edx, esi
            //   4533c0               | inc                 ecx

        $sequence_5 = { b904010000 498bc3 66443938 740b 4883c002 48ffc9 75f1 }
            // n = 7, score = 100
            //   b904010000           | dec                 eax
            //   498bc3               | mov                 ecx, esi
            //   66443938             | call                eax
            //   740b                 | dec                 eax
            //   4883c002             | test                ebp, ebp
            //   48ffc9               | je                  0x1532
            //   75f1                 | dec                 eax

        $sequence_6 = { 4883c9ff 48897c2430 33c0 488bfb 488bd6 f2ae 48f7d1 }
            // n = 7, score = 100
            //   4883c9ff             | dec                 eax
            //   48897c2430           | lea                 ecx, [0x76c0b]
            //   33c0                 | dec                 ecx
            //   488bfb               | arpl                bx, dx
            //   488bd6               | dec                 esp
            //   f2ae                 | mov                 ecx, edx
            //   48f7d1               | mov                 ecx, 0x40

        $sequence_7 = { e8???????? 488bcb ffd0 488b0d???????? 488b1d???????? c60107 40382b }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488bcb               | dec                 eax
            //   ffd0                 | lea                 ecx, [0x3c7a1]
            //   488b0d????????       |                     
            //   488b1d????????       |                     
            //   c60107               | dec                 eax
            //   40382b               | lea                 ecx, [0x6ac25]

        $sequence_8 = { 4c8d8de0030000 4c8d05306f0500 440fb7d8 488d8dd0010000 ba04010000 44895c2420 e8???????? }
            // n = 7, score = 100
            //   4c8d8de0030000       | mov                 eax, 0x200
            //   4c8d05306f0500       | jmp                 0x7ca
            //   440fb7d8             | mov                 byte ptr [edi + 0x2c], 1
            //   488d8dd0010000       | mov                 dword ptr [edi + 0x20], esi
            //   ba04010000           | jne                 0x798
            //   44895c2420           | dec                 eax
            //   e8????????           |                     

        $sequence_9 = { 498be3 415c 5f 5d c3 48895c2418 48896c2420 }
            // n = 7, score = 100
            //   498be3               | dec                 eax
            //   415c                 | lea                 ebp, [esp - 0x3f]
            //   5f                   | dec                 eax
            //   5d                   | sub                 esp, 0x88
            //   c3                   | xor                 edi, edi
            //   48895c2418           | push                esi
            //   48896c2420           | push                edi

    condition:
        7 of them and filesize < 1399808
}