rule win_lightrail_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.lightrail."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lightrail"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { b931ad0231 e8???????? 48894330 4885c0 0f8486000000 }
            // n = 5, score = 100
            //   b931ad0231           | xor                 ecx, ecx
            //   e8????????           |                     
            //   48894330             | dec                 eax
            //   4885c0               | mov                 dword ptr [esp + 0x50], eax
            //   0f8486000000         | inc                 ebp

        $sequence_1 = { 48d3c8 4533c0 33d2 33c9 ff15???????? 488d0d505b0100 eb0c }
            // n = 7, score = 100
            //   48d3c8               | je                  0x1d96
            //   4533c0               | mov                 edx, 0xc86413d4
            //   33d2                 | mov                 ecx, 0xd34c7039
            //   33c9                 | dec                 eax
            //   ff15????????         |                     
            //   488d0d505b0100       | mov                 dword ptr [ebx + 0xb8], eax
            //   eb0c                 | dec                 eax

        $sequence_2 = { 488d152c7d0000 b914000000 e8???????? 4885c0 7452 }
            // n = 5, score = 100
            //   488d152c7d0000       | dec                 ebp
            //   b914000000           | mov                 ecx, dword ptr [edi + eax*8 + 0x1a710]
            //   e8????????           |                     
            //   4885c0               | dec                 ecx
            //   7452                 | mov                 esi, ebx

        $sequence_3 = { 0f84eb000000 4885c0 0f85e4000000 4d3bc1 0f84d1000000 8b7500 498b9cf700a10100 }
            // n = 7, score = 100
            //   0f84eb000000         | dec                 eax
            //   4885c0               | lea                 ecx, [0xf677]
            //   0f85e4000000         | and                 eax, 0x3f
            //   4d3bc1               | dec                 ebp
            //   0f84d1000000         | mov                 ebp, esp
            //   8b7500               | dec                 ecx
            //   498b9cf700a10100     | sar                 ebp, 6

        $sequence_4 = { 8b0c8e 4903ca 483bcf 721a 438b84168c000000 }
            // n = 5, score = 100
            //   8b0c8e               | lea                 edx, [esp + 0x48]
            //   4903ca               | dec                 eax
            //   483bcf               | test                eax, eax
            //   721a                 | je                  0x47f
            //   438b84168c000000     | nop                 

        $sequence_5 = { 746d 4533c9 8d5772 4533c0 488bc8 ff93c8020000 }
            // n = 6, score = 100
            //   746d                 | je                  0x36f
            //   4533c9               | xor                 edx, edx
            //   8d5772               | mov                 word ptr [esp + 0x20], 0x2e
            //   4533c0               | inc                 ecx
            //   488bc8               | mov                 eax, 0x104
            //   ff93c8020000         | dec                 eax

        $sequence_6 = { 442bc9 4183f90f 7779 428b8c8ef89a0000 4803ce ffe1 }
            // n = 6, score = 100
            //   442bc9               | dec                 ecx
            //   4183f90f             | mov                 ecx, esi
            //   7779                 | inc                 esp
            //   428b8c8ef89a0000     | mov                 eax, ebx
            //   4803ce               | dec                 eax
            //   ffe1                 | lea                 edx, [0x76d0]

        $sequence_7 = { f2410f1004c1 488d15d6860000 f20f1014c2 f20f1025???????? }
            // n = 4, score = 100
            //   f2410f1004c1         | dec                 ebp
            //   488d15d6860000       | cmp                 dword ptr [eax + ecx*8 + 0x10], edx
            //   f20f1014c2           | je                  0x1075
            //   f20f1025????????     |                     

        $sequence_8 = { ff9778020000 4c63f0 4983feff 0f84ef000000 }
            // n = 4, score = 100
            //   ff9778020000         | dec                 ecx
            //   4c63f0               | mov                 ebp, eax
            //   4983feff             | dec                 esp
            //   0f84ef000000         | mov                 ebp, edx

        $sequence_9 = { 8b542430 48891401 488d0d4ab90000 e8???????? }
            // n = 4, score = 100
            //   8b542430             | inc                 ebp
            //   48891401             | mov                 ecx, ebx
            //   488d0d4ab90000       | dec                 ebp
            //   e8????????           |                     

    condition:
        7 of them and filesize < 249856
}