rule win_listrix_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.listrix."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.listrix"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 ff15???????? 85f6 0f8492000000 0fb78deef7ffff }
            // n = 5, score = 100
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85f6                 | test                esi, esi
            //   0f8492000000         | je                  0x98
            //   0fb78deef7ffff       | movzx               ecx, word ptr [ebp - 0x812]

        $sequence_1 = { 51 52 50 8d8dc0f5ffff 51 }
            // n = 5, score = 100
            //   51                   | push                ecx
            //   52                   | push                edx
            //   50                   | push                eax
            //   8d8dc0f5ffff         | lea                 ecx, [ebp - 0xa40]
            //   51                   | push                ecx

        $sequence_2 = { 55 8bec 33c0 8b4d08 3b0cc5186a4000 740a 40 }
            // n = 7, score = 100
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   33c0                 | xor                 eax, eax
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   3b0cc5186a4000       | cmp                 ecx, dword ptr [eax*8 + 0x406a18]
            //   740a                 | je                  0xc
            //   40                   | inc                 eax

        $sequence_3 = { ebe6 c745e060614000 817de064614000 7311 8b45e0 8b00 85c0 }
            // n = 7, score = 100
            //   ebe6                 | jmp                 0xffffffe8
            //   c745e060614000       | mov                 dword ptr [ebp - 0x20], 0x406160
            //   817de064614000       | cmp                 dword ptr [ebp - 0x20], 0x406164
            //   7311                 | jae                 0x13
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   85c0                 | test                eax, eax

        $sequence_4 = { 817de45c614000 7311 8b45e4 8b00 85c0 }
            // n = 5, score = 100
            //   817de45c614000       | cmp                 dword ptr [ebp - 0x1c], 0x40615c
            //   7311                 | jae                 0x13
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   85c0                 | test                eax, eax

        $sequence_5 = { 8b5510 8d46ff 50 8b8584f5ffff 51 52 }
            // n = 6, score = 100
            //   8b5510               | mov                 edx, dword ptr [ebp + 0x10]
            //   8d46ff               | lea                 eax, [esi - 1]
            //   50                   | push                eax
            //   8b8584f5ffff         | mov                 eax, dword ptr [ebp - 0xa7c]
            //   51                   | push                ecx
            //   52                   | push                edx

        $sequence_6 = { 52 ff15???????? 68???????? 8d85f4f7ffff 50 }
            // n = 5, score = 100
            //   52                   | push                edx
            //   ff15????????         |                     
            //   68????????           |                     
            //   8d85f4f7ffff         | lea                 eax, [ebp - 0x80c]
            //   50                   | push                eax

        $sequence_7 = { 668b4c4310 66890c457ca74000 40 ebe8 33c0 8945e4 3d01010000 }
            // n = 7, score = 100
            //   668b4c4310           | mov                 cx, word ptr [ebx + eax*2 + 0x10]
            //   66890c457ca74000     | mov                 word ptr [eax*2 + 0x40a77c], cx
            //   40                   | inc                 eax
            //   ebe8                 | jmp                 0xffffffea
            //   33c0                 | xor                 eax, eax
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   3d01010000           | cmp                 eax, 0x101

        $sequence_8 = { 7718 0f85b6000000 8b85a8f5ffff 3b857cf5ffff 0f86a4000000 0fb78deef7ffff }
            // n = 6, score = 100
            //   7718                 | ja                  0x1a
            //   0f85b6000000         | jne                 0xbc
            //   8b85a8f5ffff         | mov                 eax, dword ptr [ebp - 0xa58]
            //   3b857cf5ffff         | cmp                 eax, dword ptr [ebp - 0xa84]
            //   0f86a4000000         | jbe                 0xaa
            //   0fb78deef7ffff       | movzx               ecx, word ptr [ebp - 0x812]

        $sequence_9 = { 52 ff15???????? 83c428 8d85f4fbffff 50 }
            // n = 5, score = 100
            //   52                   | push                edx
            //   ff15????????         |                     
            //   83c428               | add                 esp, 0x28
            //   8d85f4fbffff         | lea                 eax, [ebp - 0x40c]
            //   50                   | push                eax

    condition:
        7 of them and filesize < 106496
}