rule win_lobshot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.lobshot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lobshot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4e08 8a86b1160000 eb10 85c0 7e12 8b5608 8b4e14 }
            // n = 7, score = 200
            //   8b4e08               | mov                 ecx, dword ptr [esi + 8]
            //   8a86b1160000         | mov                 al, byte ptr [esi + 0x16b1]
            //   eb10                 | jmp                 0x12
            //   85c0                 | test                eax, eax
            //   7e12                 | jle                 0x14
            //   8b5608               | mov                 edx, dword ptr [esi + 8]
            //   8b4e14               | mov                 ecx, dword ptr [esi + 0x14]

        $sequence_1 = { 0f8c89040000 85db b98a000000 6a07 58 0f45c8 33c0 }
            // n = 7, score = 200
            //   0f8c89040000         | jl                  0x48f
            //   85db                 | test                ebx, ebx
            //   b98a000000           | mov                 ecx, 0x8a
            //   6a07                 | push                7
            //   58                   | pop                 eax
            //   0f45c8               | cmovne              ecx, eax
            //   33c0                 | xor                 eax, eax

        $sequence_2 = { 5f c3 53 56 85c9 7462 }
            // n = 6, score = 200
            //   5f                   | pop                 edi
            //   c3                   | ret                 
            //   53                   | push                ebx
            //   56                   | push                esi
            //   85c9                 | test                ecx, ecx
            //   7462                 | je                  0x64

        $sequence_3 = { 6685c9 740a 83f92e 7405 }
            // n = 4, score = 200
            //   6685c9               | test                cx, cx
            //   740a                 | je                  0xc
            //   83f92e               | cmp                 ecx, 0x2e
            //   7405                 | je                  7

        $sequence_4 = { 8945e8 66d3e0 660b86b0160000 0fb7c0 8945f8 6a10 58 }
            // n = 7, score = 200
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   66d3e0               | shl                 ax, cl
            //   660b86b0160000       | or                  ax, word ptr [esi + 0x16b0]
            //   0fb7c0               | movzx               eax, ax
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   6a10                 | push                0x10
            //   58                   | pop                 eax

        $sequence_5 = { 8b7d18 33c9 6a0f 41 58 39b48d78ffffff 7505 }
            // n = 7, score = 200
            //   8b7d18               | mov                 edi, dword ptr [ebp + 0x18]
            //   33c9                 | xor                 ecx, ecx
            //   6a0f                 | push                0xf
            //   41                   | inc                 ecx
            //   58                   | pop                 eax
            //   39b48d78ffffff       | cmp                 dword ptr [ebp + ecx*4 - 0x88], esi
            //   7505                 | jne                 7

        $sequence_6 = { 8b4764 8a5401ff 8b8f98160000 8b879c160000 66893448 8b8798160000 8b8f90160000 }
            // n = 7, score = 200
            //   8b4764               | mov                 eax, dword ptr [edi + 0x64]
            //   8a5401ff             | mov                 dl, byte ptr [ecx + eax - 1]
            //   8b8f98160000         | mov                 ecx, dword ptr [edi + 0x1698]
            //   8b879c160000         | mov                 eax, dword ptr [edi + 0x169c]
            //   66893448             | mov                 word ptr [eax + ecx*2], si
            //   8b8798160000         | mov                 eax, dword ptr [edi + 0x1698]
            //   8b8f90160000         | mov                 ecx, dword ptr [edi + 0x1690]

        $sequence_7 = { ff35???????? 6801000080 ff15???????? 85c0 0f851e010000 55 8b2d???????? }
            // n = 7, score = 200
            //   ff35????????         |                     
            //   6801000080           | push                0x80000001
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f851e010000         | jne                 0x124
            //   55                   | push                ebp
            //   8b2d????????         |                     

        $sequence_8 = { 8b8b4c140000 8b83580b0000 8b55ec 89848b540b0000 8bcb e8???????? }
            // n = 6, score = 200
            //   8b8b4c140000         | mov                 ecx, dword ptr [ebx + 0x144c]
            //   8b83580b0000         | mov                 eax, dword ptr [ebx + 0xb58]
            //   8b55ec               | mov                 edx, dword ptr [ebp - 0x14]
            //   89848b540b0000       | mov                 dword ptr [ebx + ecx*4 + 0xb54], eax
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     

        $sequence_9 = { 83ec30 8b4204 8945d8 8b4208 53 8b1a 56 }
            // n = 7, score = 200
            //   83ec30               | sub                 esp, 0x30
            //   8b4204               | mov                 eax, dword ptr [edx + 4]
            //   8945d8               | mov                 dword ptr [ebp - 0x28], eax
            //   8b4208               | mov                 eax, dword ptr [edx + 8]
            //   53                   | push                ebx
            //   8b1a                 | mov                 ebx, dword ptr [edx]
            //   56                   | push                esi

    condition:
        7 of them and filesize < 247808
}