rule win_lockergoga_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.lockergoga."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lockergoga"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 83c718 83c618 897dec 3bf3 75eb 8bc7 }
            // n = 7, score = 400
            //   e8????????           |                     
            //   83c718               | add                 edi, 0x18
            //   83c618               | add                 esi, 0x18
            //   897dec               | mov                 dword ptr [ebp - 0x14], edi
            //   3bf3                 | cmp                 esi, ebx
            //   75eb                 | jne                 0xffffffed
            //   8bc7                 | mov                 eax, edi

        $sequence_1 = { 84c0 7405 8b7608 eb4e 8b8564ffffff 80780d00 743a }
            // n = 7, score = 400
            //   84c0                 | test                al, al
            //   7405                 | je                  7
            //   8b7608               | mov                 esi, dword ptr [esi + 8]
            //   eb4e                 | jmp                 0x50
            //   8b8564ffffff         | mov                 eax, dword ptr [ebp - 0x9c]
            //   80780d00             | cmp                 byte ptr [eax + 0xd], 0
            //   743a                 | je                  0x3c

        $sequence_2 = { c645fc1b e8???????? 8d4db4 c645fc0e e8???????? 8b4d9c 8b06 }
            // n = 7, score = 400
            //   c645fc1b             | mov                 byte ptr [ebp - 4], 0x1b
            //   e8????????           |                     
            //   8d4db4               | lea                 ecx, [ebp - 0x4c]
            //   c645fc0e             | mov                 byte ptr [ebp - 4], 0xe
            //   e8????????           |                     
            //   8b4d9c               | mov                 ecx, dword ptr [ebp - 0x64]
            //   8b06                 | mov                 eax, dword ptr [esi]

        $sequence_3 = { 56 83c0c8 50 e8???????? 837d9000 c745a800000000 0f8691000000 }
            // n = 7, score = 400
            //   56                   | push                esi
            //   83c0c8               | add                 eax, -0x38
            //   50                   | push                eax
            //   e8????????           |                     
            //   837d9000             | cmp                 dword ptr [ebp - 0x70], 0
            //   c745a800000000       | mov                 dword ptr [ebp - 0x58], 0
            //   0f8691000000         | jbe                 0x97

        $sequence_4 = { 57 8d4d9c e8???????? 8b7da0 8b45cc c645fc0b }
            // n = 6, score = 400
            //   57                   | push                edi
            //   8d4d9c               | lea                 ecx, [ebp - 0x64]
            //   e8????????           |                     
            //   8b7da0               | mov                 edi, dword ptr [ebp - 0x60]
            //   8b45cc               | mov                 eax, dword ptr [ebp - 0x34]
            //   c645fc0b             | mov                 byte ptr [ebp - 4], 0xb

        $sequence_5 = { 8365ec00 ff75ec e8???????? 59 0fb6c0 85c0 7408 }
            // n = 7, score = 400
            //   8365ec00             | and                 dword ptr [ebp - 0x14], 0
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   0fb6c0               | movzx               eax, al
            //   85c0                 | test                eax, eax
            //   7408                 | je                  0xa

        $sequence_6 = { 51 50 e8???????? 8b45ec 83c408 c7461000000000 c746140f000000 }
            // n = 7, score = 400
            //   51                   | push                ecx
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   83c408               | add                 esp, 8
            //   c7461000000000       | mov                 dword ptr [esi + 0x10], 0
            //   c746140f000000       | mov                 dword ptr [esi + 0x14], 0xf

        $sequence_7 = { 895108 50 8bce e8???????? 8b560c 8d4508 50 }
            // n = 7, score = 400
            //   895108               | mov                 dword ptr [ecx + 8], edx
            //   50                   | push                eax
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   8b560c               | mov                 edx, dword ptr [esi + 0xc]
            //   8d4508               | lea                 eax, [ebp + 8]
            //   50                   | push                eax

        $sequence_8 = { 6a08 8975ec c7450800000000 c70600000000 c7460400000000 c7460800000000 c7460c00000000 }
            // n = 7, score = 400
            //   6a08                 | push                8
            //   8975ec               | mov                 dword ptr [ebp - 0x14], esi
            //   c7450800000000       | mov                 dword ptr [ebp + 8], 0
            //   c70600000000         | mov                 dword ptr [esi], 0
            //   c7460400000000       | mov                 dword ptr [esi + 4], 0
            //   c7460800000000       | mov                 dword ptr [esi + 8], 0
            //   c7460c00000000       | mov                 dword ptr [esi + 0xc], 0

        $sequence_9 = { 8b4da0 c6400100 8808 e9???????? b8ffffff7f 2bc1 83f801 }
            // n = 7, score = 400
            //   8b4da0               | mov                 ecx, dword ptr [ebp - 0x60]
            //   c6400100             | mov                 byte ptr [eax + 1], 0
            //   8808                 | mov                 byte ptr [eax], cl
            //   e9????????           |                     
            //   b8ffffff7f           | mov                 eax, 0x7fffffff
            //   2bc1                 | sub                 eax, ecx
            //   83f801               | cmp                 eax, 1

    condition:
        7 of them and filesize < 2588672
}