rule win_lockfile_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.lockfile."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lockfile"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 48f76328 498d0c00 488b4630 493bc8 4883d200 4c03e2 488955f7 }
            // n = 7, score = 200
            //   48f76328             | lea                 eax, [edx + ecx]
            //   498d0c00             | dec                 ecx
            //   488b4630             | adc                 eax, 0
            //   493bc8               | dec                 ebp
            //   4883d200             | cmp                 esi, edi
            //   4c03e2               | dec                 ecx
            //   488955f7             | adc                 eax, 0

        $sequence_1 = { 48896c2418 56 4156 4157 4883ec30 498be9 4d8bf0 }
            // n = 7, score = 200
            //   48896c2418           | dec                 ecx
            //   56                   | mov                 eax, dword ptr [edi + 0x28]
            //   4156                 | dec                 eax
            //   4157                 | cmp                 ebx, esi
            //   4883ec30             | inc                 ecx
            //   498be9               | mov                 esi, esi
            //   4d8bf0               | dec                 ecx

        $sequence_2 = { c784249000000002000000 4c8bc7 488bd7 488d4c2420 e8???????? 90 4c8d4318 }
            // n = 7, score = 200
            //   c784249000000002000000     | inc    ebp
            //   4c8bc7               | xor                 ecx, ecx
            //   488bd7               | dec                 eax
            //   488d4c2420           | mov                 edx, dword ptr [ecx + 0x38]
            //   e8????????           |                     
            //   90                   | call                dword ptr [eax + 0x30]
            //   4c8d4318             | je                  0x477

        $sequence_3 = { 4898 488d0d74280700 8b542438 ffc2 8bd2 4c8b442430 418b1490 }
            // n = 7, score = 200
            //   4898                 | mov                 eax, dword ptr [ebp]
            //   488d0d74280700       | dec                 ebp
            //   8b542438             | cmp                 eax, ecx
            //   ffc2                 | dec                 eax
            //   8bd2                 | adc                 ecx, 0
            //   4c8b442430           | dec                 ecx
            //   418b1490             | mul                 dword ptr [ebp + 8]

        $sequence_4 = { e8???????? cc 4057 4883ec20 488b5110 }
            // n = 5, score = 200
            //   e8????????           |                     
            //   cc                   | cmp                 esi, edi
            //   4057                 | dec                 esp
            //   4883ec20             | mov                 esi, dword ptr [ebp + 0xf]
            //   488b5110             | dec                 esp

        $sequence_5 = { 498b4348 493bc8 4883d200 4c03e2 48895587 48f76650 4c8d0401 }
            // n = 7, score = 200
            //   498b4348             | dec                 eax
            //   493bc8               | mul                 dword ptr [ebx + 0x58]
            //   4883d200             | dec                 ebp
            //   4c03e2               | add                 esp, ebp
            //   48895587             | dec                 esp
            //   48f76650             | mov                 esi, edx
            //   4c8d0401             | dec                 ecx

        $sequence_6 = { 48f76118 4c894df0 4c8bea 488d0c03 483bcb 488b5d50 4983d500 }
            // n = 7, score = 200
            //   48f76118             | shr                 esi, 2
            //   4c894df0             | dec                 eax
            //   4c8bea               | lea                 eax, [0x62a0a]
            //   488d0c03             | dec                 ebp
            //   483bcb               | mov                 eax, ecx
            //   488b5d50             | dec                 ecx
            //   4983d500             | mov                 edx, edi

        $sequence_7 = { 4433d5 41c1c802 4403d0 81c59979825a 4503d3 448bda 4533d8 }
            // n = 7, score = 200
            //   4433d5               | inc                 esp
            //   41c1c802             | mov                 dword ptr [esp + 4], esi
            //   4403d0               | inc                 ecx
            //   81c59979825a         | xor                 ecx, ecx
            //   4503d3               | inc                 ecx
            //   448bda               | xor                 ecx, edx
            //   4533d8               | add                 eax, 0x6ed9eba1

        $sequence_8 = { 488d059fdf0700 bf04000000 48895c2450 4c8be1 8bd7 488d4c2460 6666660f1f840000000000 }
            // n = 7, score = 200
            //   488d059fdf0700       | mul                 dword ptr [edi + 0x78]
            //   bf04000000           | dec                 esi
            //   48895c2450           | lea                 edx, [ebx + ebx]
            //   4c8be1               | dec                 ecx
            //   8bd7                 | add                 eax, eax
            //   488d4c2460           | dec                 esp
            //   6666660f1f840000000000     | mov    ecx, edx

        $sequence_9 = { 418bcd 4103d4 c1c90d 448b2424 4103d0 418bc5 4403e2 }
            // n = 7, score = 200
            //   418bcd               | inc                 ecx
            //   4103d4               | ror                 ecx, 2
            //   c1c90d               | add                 ecx, eax
            //   448b2424             | add                 edx, 0x6ed9eba1
            //   4103d0               | inc                 esp
            //   418bc5               | add                 ebx, ecx
            //   4403e2               | inc                 ecx

    condition:
        7 of them and filesize < 1163264
}