rule win_locky_decryptor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.locky_decryptor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.locky_decryptor"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 03049500c14100 eb05 b8???????? f6400420 }
            // n = 4, score = 100
            //   03049500c14100       | add                 eax, dword ptr [edx*4 + 0x41c100]
            //   eb05                 | jmp                 7
            //   b8????????           |                     
            //   f6400420             | test                byte ptr [eax + 4], 0x20

        $sequence_1 = { 7202 8b1b 837dec08 8b4dd8 7303 8d4dd8 03c0 }
            // n = 7, score = 100
            //   7202                 | jb                  4
            //   8b1b                 | mov                 ebx, dword ptr [ebx]
            //   837dec08             | cmp                 dword ptr [ebp - 0x14], 8
            //   8b4dd8               | mov                 ecx, dword ptr [ebp - 0x28]
            //   7303                 | jae                 5
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   03c0                 | add                 eax, eax

        $sequence_2 = { 395ddc 7413 837de008 8b45cc 7303 }
            // n = 5, score = 100
            //   395ddc               | cmp                 dword ptr [ebp - 0x24], ebx
            //   7413                 | je                  0x15
            //   837de008             | cmp                 dword ptr [ebp - 0x20], 8
            //   8b45cc               | mov                 eax, dword ptr [ebp - 0x34]
            //   7303                 | jae                 5

        $sequence_3 = { 8bf7 83e61f c1e606 03348500c14100 }
            // n = 4, score = 100
            //   8bf7                 | mov                 esi, edi
            //   83e61f               | and                 esi, 0x1f
            //   c1e606               | shl                 esi, 6
            //   03348500c14100       | add                 esi, dword ptr [eax*4 + 0x41c100]

        $sequence_4 = { 8b4dfa 33c0 4a 49 668945e8 668945ea 6a27 }
            // n = 7, score = 100
            //   8b4dfa               | mov                 ecx, dword ptr [ebp - 6]
            //   33c0                 | xor                 eax, eax
            //   4a                   | dec                 edx
            //   49                   | dec                 ecx
            //   668945e8             | mov                 word ptr [ebp - 0x18], ax
            //   668945ea             | mov                 word ptr [ebp - 0x16], ax
            //   6a27                 | push                0x27

        $sequence_5 = { 50 33c9 8d7d08 8975f0 e8???????? 83cbff }
            // n = 6, score = 100
            //   50                   | push                eax
            //   33c9                 | xor                 ecx, ecx
            //   8d7d08               | lea                 edi, [ebp + 8]
            //   8975f0               | mov                 dword ptr [ebp - 0x10], esi
            //   e8????????           |                     
            //   83cbff               | or                  ebx, 0xffffffff

        $sequence_6 = { 6830010000 e8???????? 33db 59 59 3bc3 7509 }
            // n = 7, score = 100
            //   6830010000           | push                0x130
            //   e8????????           |                     
            //   33db                 | xor                 ebx, ebx
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   3bc3                 | cmp                 eax, ebx
            //   7509                 | jne                 0xb

        $sequence_7 = { e8???????? 8b5e04 8b0e 8bc3 2bc1 99 f7ff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b5e04               | mov                 ebx, dword ptr [esi + 4]
            //   8b0e                 | mov                 ecx, dword ptr [esi]
            //   8bc3                 | mov                 eax, ebx
            //   2bc1                 | sub                 eax, ecx
            //   99                   | cdq                 
            //   f7ff                 | idiv                edi

        $sequence_8 = { 8b45ec 8b08 890b 8938 397df0 740a 57 }
            // n = 7, score = 100
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   890b                 | mov                 dword ptr [ebx], ecx
            //   8938                 | mov                 dword ptr [eax], edi
            //   397df0               | cmp                 dword ptr [ebp - 0x10], edi
            //   740a                 | je                  0xc
            //   57                   | push                edi

        $sequence_9 = { e8???????? 6a01 33ff 8d75d8 e8???????? 8b450c 8b4df4 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   6a01                 | push                1
            //   33ff                 | xor                 edi, edi
            //   8d75d8               | lea                 esi, [ebp - 0x28]
            //   e8????????           |                     
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]

    condition:
        7 of them and filesize < 278528
}