rule win_lodeinfo_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.lodeinfo."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lodeinfo"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85db 742a 8b4c2420 8bc3 2bcb 81f900100000 }
            // n = 6, score = 200
            //   85db                 | test                ebx, ebx
            //   742a                 | je                  0x2c
            //   8b4c2420             | mov                 ecx, dword ptr [esp + 0x20]
            //   8bc3                 | mov                 eax, ebx
            //   2bcb                 | sub                 ecx, ebx
            //   81f900100000         | cmp                 ecx, 0x1000

        $sequence_1 = { 7418 8b4114 3b4614 753f 8b4118 3b4618 7537 }
            // n = 7, score = 200
            //   7418                 | je                  0x1a
            //   8b4114               | mov                 eax, dword ptr [ecx + 0x14]
            //   3b4614               | cmp                 eax, dword ptr [esi + 0x14]
            //   753f                 | jne                 0x41
            //   8b4118               | mov                 eax, dword ptr [ecx + 0x18]
            //   3b4618               | cmp                 eax, dword ptr [esi + 0x18]
            //   7537                 | jne                 0x39

        $sequence_2 = { ba???????? b9???????? e8???????? 50 e8???????? 8b5c2448 83c404 }
            // n = 7, score = 200
            //   ba????????           |                     
            //   b9????????           |                     
            //   e8????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b5c2448             | mov                 ebx, dword ptr [esp + 0x48]
            //   83c404               | add                 esp, 4

        $sequence_3 = { 8b8d34ffffff 8bfe c1ef03 0fafcf }
            // n = 4, score = 200
            //   8b8d34ffffff         | mov                 ecx, dword ptr [ebp - 0xcc]
            //   8bfe                 | mov                 edi, esi
            //   c1ef03               | shr                 edi, 3
            //   0fafcf               | imul                ecx, edi

        $sequence_4 = { 83c404 46 83fe10 75e3 5f }
            // n = 5, score = 200
            //   83c404               | add                 esp, 4
            //   46                   | inc                 esi
            //   83fe10               | cmp                 esi, 0x10
            //   75e3                 | jne                 0xffffffe5
            //   5f                   | pop                 edi

        $sequence_5 = { 8955e4 81faff000000 7756 8b55f8 8b4308 8b3a 47 }
            // n = 7, score = 200
            //   8955e4               | mov                 dword ptr [ebp - 0x1c], edx
            //   81faff000000         | cmp                 edx, 0xff
            //   7756                 | ja                  0x58
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   8b4308               | mov                 eax, dword ptr [ebx + 8]
            //   8b3a                 | mov                 edi, dword ptr [edx]
            //   47                   | inc                 edi

        $sequence_6 = { b22d e8???????? 83eb01 75f4 b22b e8???????? 50 }
            // n = 7, score = 200
            //   b22d                 | mov                 dl, 0x2d
            //   e8????????           |                     
            //   83eb01               | sub                 ebx, 1
            //   75f4                 | jne                 0xfffffff6
            //   b22b                 | mov                 dl, 0x2b
            //   e8????????           |                     
            //   50                   | push                eax

        $sequence_7 = { 23c7 03d8 895de4 8b7d0c 8bcf }
            // n = 5, score = 200
            //   23c7                 | and                 eax, edi
            //   03d8                 | add                 ebx, eax
            //   895de4               | mov                 dword ptr [ebp - 0x1c], ebx
            //   8b7d0c               | mov                 edi, dword ptr [ebp + 0xc]
            //   8bcf                 | mov                 ecx, edi

        $sequence_8 = { 0fb65204 c1e218 d3e2 0bd3 8b5de4 eb68 c7461000000000 }
            // n = 7, score = 200
            //   0fb65204             | movzx               edx, byte ptr [edx + 4]
            //   c1e218               | shl                 edx, 0x18
            //   d3e2                 | shl                 edx, cl
            //   0bd3                 | or                  edx, ebx
            //   8b5de4               | mov                 ebx, dword ptr [ebp - 0x1c]
            //   eb68                 | jmp                 0x6a
            //   c7461000000000       | mov                 dword ptr [esi + 0x10], 0

        $sequence_9 = { 83c404 83f810 722b 8b4c242c 8d5001 8bc1 81fa00100000 }
            // n = 7, score = 200
            //   83c404               | add                 esp, 4
            //   83f810               | cmp                 eax, 0x10
            //   722b                 | jb                  0x2d
            //   8b4c242c             | mov                 ecx, dword ptr [esp + 0x2c]
            //   8d5001               | lea                 edx, [eax + 1]
            //   8bc1                 | mov                 eax, ecx
            //   81fa00100000         | cmp                 edx, 0x1000

    condition:
        7 of them and filesize < 712704
}