rule win_lokipws_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.lokipws."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lokipws"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a62 668945f8 58 668945fa 33c0 50 50 }
            // n = 7, score = 300
            //   6a62                 | push                0x62
            //   668945f8             | mov                 word ptr [ebp - 8], ax
            //   58                   | pop                 eax
            //   668945fa             | mov                 word ptr [ebp - 6], ax
            //   33c0                 | xor                 eax, eax
            //   50                   | push                eax
            //   50                   | push                eax

        $sequence_1 = { 6a0a e8???????? 59 33db 6a2e 5e }
            // n = 6, score = 300
            //   6a0a                 | push                0xa
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   33db                 | xor                 ebx, ebx
            //   6a2e                 | push                0x2e
            //   5e                   | pop                 esi

        $sequence_2 = { 55 8bec 6a00 6a00 686c425ad4 6a09 }
            // n = 6, score = 300
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   686c425ad4           | push                0xd45a426c
            //   6a09                 | push                9

        $sequence_3 = { 56 57 50 e8???????? 53 56 8d8574ffffff }
            // n = 7, score = 300
            //   56                   | push                esi
            //   57                   | push                edi
            //   50                   | push                eax
            //   e8????????           |                     
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8d8574ffffff         | lea                 eax, [ebp - 0x8c]

        $sequence_4 = { 53 50 8d8550ffffff 50 e8???????? 83c424 }
            // n = 6, score = 300
            //   53                   | push                ebx
            //   50                   | push                eax
            //   8d8550ffffff         | lea                 eax, [ebp - 0xb0]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c424               | add                 esp, 0x24

        $sequence_5 = { 85c0 745c 8b9d68ffffff 0fb603 89855cffffff 8b8564ffffff }
            // n = 6, score = 300
            //   85c0                 | test                eax, eax
            //   745c                 | je                  0x5e
            //   8b9d68ffffff         | mov                 ebx, dword ptr [ebp - 0x98]
            //   0fb603               | movzx               eax, byte ptr [ebx]
            //   89855cffffff         | mov                 dword ptr [ebp - 0xa4], eax
            //   8b8564ffffff         | mov                 eax, dword ptr [ebp - 0x9c]

        $sequence_6 = { eb1f ff75ec 50 e8???????? 59 59 85c0 }
            // n = 7, score = 300
            //   eb1f                 | jmp                 0x21
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax

        $sequence_7 = { ff36 e8???????? 33c0 891e 83c41c }
            // n = 5, score = 300
            //   ff36                 | push                dword ptr [esi]
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   891e                 | mov                 dword ptr [esi], ebx
            //   83c41c               | add                 esp, 0x1c

        $sequence_8 = { 6a2e 5a 6a64 59 6a6c 5e }
            // n = 6, score = 300
            //   6a2e                 | push                0x2e
            //   5a                   | pop                 edx
            //   6a64                 | push                0x64
            //   59                   | pop                 ecx
            //   6a6c                 | push                0x6c
            //   5e                   | pop                 esi

        $sequence_9 = { e8???????? 8d4df8 51 57 57 6a01 }
            // n = 6, score = 300
            //   e8????????           |                     
            //   8d4df8               | lea                 ecx, [ebp - 8]
            //   51                   | push                ecx
            //   57                   | push                edi
            //   57                   | push                edi
            //   6a01                 | push                1

    condition:
        7 of them and filesize < 1327104
}