rule win_longwatch_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.longwatch."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.longwatch"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83fb12 741e 83fb03 7419 }
            // n = 4, score = 200
            //   83fb12               | cmp                 ebx, 0x12
            //   741e                 | je                  0x20
            //   83fb03               | cmp                 ebx, 3
            //   7419                 | je                  0x1b

        $sequence_1 = { 8b4004 c74410e8a0bb4200 8b42e8 8b4804 8d41e8 894411e4 }
            // n = 6, score = 200
            //   8b4004               | mov                 eax, dword ptr [eax + 4]
            //   c74410e8a0bb4200     | mov                 dword ptr [eax + edx - 0x18], 0x42bba0
            //   8b42e8               | mov                 eax, dword ptr [edx - 0x18]
            //   8b4804               | mov                 ecx, dword ptr [eax + 4]
            //   8d41e8               | lea                 eax, [ecx - 0x18]
            //   894411e4             | mov                 dword ptr [ecx + edx - 0x1c], eax

        $sequence_2 = { 750b 8b0d???????? e8???????? e8???????? 83ec18 }
            // n = 5, score = 200
            //   750b                 | jne                 0xd
            //   8b0d????????         |                     
            //   e8????????           |                     
            //   e8????????           |                     
            //   83ec18               | sub                 esp, 0x18

        $sequence_3 = { 8d8d48ffffff 68???????? e8???????? 85c0 8d8d30ffffff 8b8530ffffff }
            // n = 6, score = 200
            //   8d8d48ffffff         | lea                 ecx, [ebp - 0xb8]
            //   68????????           |                     
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   8d8d30ffffff         | lea                 ecx, [ebp - 0xd0]
            //   8b8530ffffff         | mov                 eax, dword ptr [ebp - 0xd0]

        $sequence_4 = { 33f6 3bc8 740c 8b0cb5f8344200 46 }
            // n = 5, score = 200
            //   33f6                 | xor                 esi, esi
            //   3bc8                 | cmp                 ecx, eax
            //   740c                 | je                  0xe
            //   8b0cb5f8344200       | mov                 ecx, dword ptr [esi*4 + 0x4234f8]
            //   46                   | inc                 esi

        $sequence_5 = { e8???????? 83ec14 c645fc02 8bcc 8bd0 51 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   83ec14               | sub                 esp, 0x14
            //   c645fc02             | mov                 byte ptr [ebp - 4], 2
            //   8bcc                 | mov                 ecx, esp
            //   8bd0                 | mov                 edx, eax
            //   51                   | push                ecx

        $sequence_6 = { c705????????01000000 c705????????01000000 6a04 58 6bc000 8b4d08 898894004300 }
            // n = 7, score = 200
            //   c705????????01000000     |     
            //   c705????????01000000     |     
            //   6a04                 | push                4
            //   58                   | pop                 eax
            //   6bc000               | imul                eax, eax, 0
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   898894004300         | mov                 dword ptr [eax + 0x430094], ecx

        $sequence_7 = { eb0f 8ad3 8d8d40ffffff e8???????? 8ad3 }
            // n = 5, score = 200
            //   eb0f                 | jmp                 0x11
            //   8ad3                 | mov                 dl, bl
            //   8d8d40ffffff         | lea                 ecx, [ebp - 0xc0]
            //   e8????????           |                     
            //   8ad3                 | mov                 dl, bl

        $sequence_8 = { 1bc0 83c801 85c0 745b e8???????? }
            // n = 5, score = 200
            //   1bc0                 | sbb                 eax, eax
            //   83c801               | or                  eax, 1
            //   85c0                 | test                eax, eax
            //   745b                 | je                  0x5d
            //   e8????????           |                     

        $sequence_9 = { 8d8d48ffffff c78548ffffffdc334200 e8???????? 83ec08 c745fc02000000 }
            // n = 5, score = 200
            //   8d8d48ffffff         | lea                 ecx, [ebp - 0xb8]
            //   c78548ffffffdc334200     | mov    dword ptr [ebp - 0xb8], 0x4233dc
            //   e8????????           |                     
            //   83ec08               | sub                 esp, 8
            //   c745fc02000000       | mov                 dword ptr [ebp - 4], 2

    condition:
        7 of them and filesize < 647168
}