rule win_lookback_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.lookback."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lookback"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b7c241c 33ed 8b473c 8b443878 03c7 8b5024 }
            // n = 6, score = 200
            //   8b7c241c             | mov                 edi, dword ptr [esp + 0x1c]
            //   33ed                 | xor                 ebp, ebp
            //   8b473c               | mov                 eax, dword ptr [edi + 0x3c]
            //   8b443878             | mov                 eax, dword ptr [eax + edi + 0x78]
            //   03c7                 | add                 eax, edi
            //   8b5024               | mov                 edx, dword ptr [eax + 0x24]

        $sequence_1 = { 393d???????? 75af eb24 8b0d???????? }
            // n = 4, score = 200
            //   393d????????         |                     
            //   75af                 | jne                 0xffffffb1
            //   eb24                 | jmp                 0x26
            //   8b0d????????         |                     

        $sequence_2 = { 8b542430 894308 8b442428 83c414 }
            // n = 4, score = 200
            //   8b542430             | mov                 edx, dword ptr [esp + 0x30]
            //   894308               | mov                 dword ptr [ebx + 8], eax
            //   8b442428             | mov                 eax, dword ptr [esp + 0x28]
            //   83c414               | add                 esp, 0x14

        $sequence_3 = { 8b31 25ff0f0000 03c6 8bf7 }
            // n = 4, score = 200
            //   8b31                 | mov                 esi, dword ptr [ecx]
            //   25ff0f0000           | and                 eax, 0xfff
            //   03c6                 | add                 eax, esi
            //   8bf7                 | mov                 esi, edi

        $sequence_4 = { 8b7af8 83c228 03f8 8bc1 c1e902 f3a5 }
            // n = 6, score = 200
            //   8b7af8               | mov                 edi, dword ptr [edx - 8]
            //   83c228               | add                 edx, 0x28
            //   03f8                 | add                 edi, eax
            //   8bc1                 | mov                 eax, ecx
            //   c1e902               | shr                 ecx, 2
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]

        $sequence_5 = { 668b4b06 3be9 7cd0 5f 5e }
            // n = 5, score = 200
            //   668b4b06             | mov                 cx, word ptr [ebx + 6]
            //   3be9                 | cmp                 ebp, ecx
            //   7cd0                 | jl                  0xffffffd2
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_6 = { 7422 6a00 8d4c2404 6a20 51 6a03 }
            // n = 6, score = 200
            //   7422                 | je                  0x24
            //   6a00                 | push                0
            //   8d4c2404             | lea                 ecx, [esp + 4]
            //   6a20                 | push                0x20
            //   51                   | push                ecx
            //   6a03                 | push                3

        $sequence_7 = { ff15???????? 8d542400 52 e8???????? 33c0 81c408010000 }
            // n = 6, score = 200
            //   ff15????????         |                     
            //   8d542400             | lea                 edx, [esp]
            //   52                   | push                edx
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   81c408010000         | add                 esp, 0x108

        $sequence_8 = { 5b 81c410070000 c3 55 8bec 51 53 }
            // n = 7, score = 200
            //   5b                   | pop                 ebx
            //   81c410070000         | add                 esp, 0x710
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   51                   | push                ecx
            //   53                   | push                ebx

        $sequence_9 = { 3bef 741b 6800800000 57 }
            // n = 4, score = 200
            //   3bef                 | cmp                 ebp, edi
            //   741b                 | je                  0x1d
            //   6800800000           | push                0x8000
            //   57                   | push                edi

    condition:
        7 of them and filesize < 131072
}