rule win_lowball_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.lowball."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lowball"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 0f848d000000 8d842434070000 68???????? }
            // n = 4, score = 100
            //   85c0                 | test                eax, eax
            //   0f848d000000         | je                  0x93
            //   8d842434070000       | lea                 eax, [esp + 0x734]
            //   68????????           |                     

        $sequence_1 = { 8d4b01 51 e8???????? 56 }
            // n = 4, score = 100
            //   8d4b01               | lea                 ecx, [ebx + 1]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   56                   | push                esi

        $sequence_2 = { 85f6 89742410 0f84bf000000 8b8c241c020000 }
            // n = 4, score = 100
            //   85f6                 | test                esi, esi
            //   89742410             | mov                 dword ptr [esp + 0x10], esi
            //   0f84bf000000         | je                  0xc5
            //   8b8c241c020000       | mov                 ecx, dword ptr [esp + 0x21c]

        $sequence_3 = { 6810270000 ff15???????? bf???????? 83c9ff }
            // n = 4, score = 100
            //   6810270000           | push                0x2710
            //   ff15????????         |                     
            //   bf????????           |                     
            //   83c9ff               | or                  ecx, 0xffffffff

        $sequence_4 = { 0f840c010000 8b8c2424020000 53 55 55 }
            // n = 5, score = 100
            //   0f840c010000         | je                  0x112
            //   8b8c2424020000       | mov                 ecx, dword ptr [esp + 0x224]
            //   53                   | push                ebx
            //   55                   | push                ebp
            //   55                   | push                ebp

        $sequence_5 = { 896c2418 c744242400020000 aa e8???????? 55 }
            // n = 5, score = 100
            //   896c2418             | mov                 dword ptr [esp + 0x18], ebp
            //   c744242400020000     | mov                 dword ptr [esp + 0x24], 0x200
            //   aa                   | stosb               byte ptr es:[edi], al
            //   e8????????           |                     
            //   55                   | push                ebp

        $sequence_6 = { 84c0 750b 33c0 81c4400e0000 c21000 }
            // n = 5, score = 100
            //   84c0                 | test                al, al
            //   750b                 | jne                 0xd
            //   33c0                 | xor                 eax, eax
            //   81c4400e0000         | add                 esp, 0xe40
            //   c21000               | ret                 0x10

        $sequence_7 = { 68???????? e8???????? 83c410 85c0 0f848d000000 8d842434070000 }
            // n = 6, score = 100
            //   68????????           |                     
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   85c0                 | test                eax, eax
            //   0f848d000000         | je                  0x93
            //   8d842434070000       | lea                 eax, [esp + 0x734]

        $sequence_8 = { 85c0 752d 68b80b0000 ffd3 8d84242c050000 8d8c241c010000 50 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   752d                 | jne                 0x2f
            //   68b80b0000           | push                0xbb8
            //   ffd3                 | call                ebx
            //   8d84242c050000       | lea                 eax, [esp + 0x52c]
            //   8d8c241c010000       | lea                 ecx, [esp + 0x11c]
            //   50                   | push                eax

        $sequence_9 = { 8b742420 53 ff15???????? 5b 56 ff15???????? 8b44240c }
            // n = 7, score = 100
            //   8b742420             | mov                 esi, dword ptr [esp + 0x20]
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   5b                   | pop                 ebx
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8b44240c             | mov                 eax, dword ptr [esp + 0xc]

    condition:
        7 of them and filesize < 40960
}