rule win_lowzero_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.lowzero."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lowzero"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 5e 5b c70016000000 33c0 }
            // n = 4, score = 200
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   c70016000000         | mov                 dword ptr [eax], 0x16
            //   33c0                 | xor                 eax, eax

        $sequence_1 = { 33c0 8be5 5d c3 e8???????? 5f 5e }
            // n = 7, score = 200
            //   33c0                 | xor                 eax, eax
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   e8????????           |                     
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_2 = { 5d c3 8b4b3c 894df8 8d81f8000000 3bd0 72e0 }
            // n = 7, score = 200
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8b4b3c               | mov                 ecx, dword ptr [ebx + 0x3c]
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   8d81f8000000         | lea                 eax, [ecx + 0xf8]
            //   3bd0                 | cmp                 edx, eax
            //   72e0                 | jb                  0xffffffe2

        $sequence_3 = { 2bce 894df0 8d9b00000000 8d1c31 ff7734 85c0 }
            // n = 6, score = 200
            //   2bce                 | sub                 ecx, esi
            //   894df0               | mov                 dword ptr [ebp - 0x10], ecx
            //   8d9b00000000         | lea                 ebx, [ebx]
            //   8d1c31               | lea                 ebx, [ecx + esi]
            //   ff7734               | push                dword ptr [edi + 0x34]
            //   85c0                 | test                eax, eax

        $sequence_4 = { 4b 75f7 8b4d0c 3b7dfc 0f8255feffff }
            // n = 5, score = 200
            //   4b                   | dec                 ebx
            //   75f7                 | jne                 0xfffffff9
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   3b7dfc               | cmp                 edi, dword ptr [ebp - 4]
            //   0f8255feffff         | jb                  0xfffffe5b

        $sequence_5 = { 47 2bc8 8d4602 03c3 3b450c }
            // n = 5, score = 200
            //   47                   | inc                 edi
            //   2bc8                 | sub                 ecx, eax
            //   8d4602               | lea                 eax, [esi + 2]
            //   03c3                 | add                 eax, ebx
            //   3b450c               | cmp                 eax, dword ptr [ebp + 0xc]

        $sequence_6 = { 8b3e 0fb74706 3945f8 0f8c5affffff }
            // n = 4, score = 200
            //   8b3e                 | mov                 edi, dword ptr [esi]
            //   0fb74706             | movzx               eax, word ptr [edi + 6]
            //   3945f8               | cmp                 dword ptr [ebp - 8], eax
            //   0f8c5affffff         | jl                  0xffffff60

        $sequence_7 = { 83fa40 7310 6a0d ff15???????? 5e 33c0 5b }
            // n = 7, score = 200
            //   83fa40               | cmp                 edx, 0x40
            //   7310                 | jae                 0x12
            //   6a0d                 | push                0xd
            //   ff15????????         |                     
            //   5e                   | pop                 esi
            //   33c0                 | xor                 eax, eax
            //   5b                   | pop                 ebx

        $sequence_8 = { 8b45f8 ff740854 51 56 }
            // n = 4, score = 200
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   ff740854             | push                dword ptr [eax + ecx + 0x54]
            //   51                   | push                ecx
            //   56                   | push                esi

        $sequence_9 = { 8806 46 47 e9???????? 8bda }
            // n = 5, score = 200
            //   8806                 | mov                 byte ptr [esi], al
            //   46                   | inc                 esi
            //   47                   | inc                 edi
            //   e9????????           |                     
            //   8bda                 | mov                 ebx, edx

    condition:
        7 of them and filesize < 433152
}