rule win_luca_stealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.luca_stealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.luca_stealer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb0a f6471280 7504 6683e914 4d85f6 7416 6641395e10 }
            // n = 7, score = 100
            //   eb0a                 | lea                 esi, [esp + 0x20]
            //   f6471280             | jmp                 0x177
            //   7504                 | cmp                 byte ptr [ebx + 8], 0
            //   6683e914             | je                  0x1d0
            //   4d85f6               | mov                 byte ptr [ebx + 8], 0
            //   7416                 | cmp                 al, 0x5d
            //   6641395e10           | je                  0x1c2

        $sequence_1 = { e8???????? 85c0 7428 85db 7524 488d0daee71600 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   85c0                 | mov                 ecx, dword ptr [ebp - 0x19]
            //   7428                 | dec                 eax
            //   85db                 | lea                 eax, [ebp + 0x57]
            //   7524                 | or                  dword ptr [ebp - 0x35], 0xffffffff
            //   488d0daee71600       | test                eax, eax
            //   e8????????           |                     

        $sequence_2 = { e9???????? 4156 56 57 53 4883ec28 83791803 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   4156                 | dec                 eax
            //   56                   | lea                 edx, [0x25a238]
            //   57                   | dec                 eax
            //   53                   | mov                 ecx, ebp
            //   4883ec28             | inc                 eax
            //   83791803             | cmp                 byte ptr [esi + 0x1c4], bh

        $sequence_3 = { e8???????? 4c8d4768 4889f1 ba03003000 e8???????? 4883c770 4889f1 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4c8d4768             | dec                 esp
            //   4889f1               | mov                 eax, dword ptr [esp + 0x30]
            //   ba03003000           | dec                 ebx
            //   e8????????           |                     
            //   4883c770             | lea                 ecx, [esi + edi]
            //   4889f1               | dec                 esp

        $sequence_4 = { eb06 492130 412131 488b5c2430 8bc6 488b742438 488b7c2440 }
            // n = 7, score = 100
            //   eb06                 | mov                 dword ptr [ecx + 1], eax
            //   492130               | mov                 byte ptr [ecx + 9], dl
            //   412131               | jmp                 0x1d8
            //   488b5c2430           | mov                 ebx, dword ptr [esp + 0x58]
            //   8bc6                 | inc                 edi
            //   488b742438           | mov                 ebx, dword ptr [esp + 0x48]
            //   488b7c2440           | mov                 eax, dword ptr [esp + 0x74]

        $sequence_5 = { 8d507e 448d4301 e8???????? 8b442458 448d4301 448bce 89442420 }
            // n = 7, score = 100
            //   8d507e               | cmp                 edx, ecx
            //   448d4301             | mov                 ecx, edi
            //   e8????????           |                     
            //   8b442458             | inc                 ecx
            //   448d4301             | mov                 eax, ebx
            //   448bce               | shr                 ecx, 6
            //   89442420             | or                  cl, 0xc0

        $sequence_6 = { e9???????? 48b8af39a3b04c5dea12 c3 56 4883ec20 4889ce 89f0 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   48b8af39a3b04c5dea12     | shl    edx, 4
            //   c3                   | dec                 eax
            //   56                   | add                 edx, dword ptr [edi + 0x78]
            //   4883ec20             | inc                 ecx
            //   4889ce               | sub                 eax, 2
            //   89f0                 | je                  0x6c9

        $sequence_7 = { ff15???????? 4438bfa8010000 740c 488b8fe8010000 e8???????? 488bcf e8???????? }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   4438bfa8010000       | jne                 0xd2c
            //   740c                 | inc                 esp
            //   488b8fe8010000       | cmp                 esp, dword ptr [ebp - 0x15]
            //   e8????????           |                     
            //   488bcf               | jge                 0xd2c
            //   e8????????           |                     

        $sequence_8 = { e8???????? 488d8d60110000 e8???????? 488d8d501f0000 e8???????? 488d15683a2c00 488db560110000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488d8d60110000       | dec                 eax
            //   e8????????           |                     
            //   488d8d501f0000       | mov                 ecx, esi
            //   e8????????           |                     
            //   488d15683a2c00       | dec                 eax
            //   488db560110000       | mov                 edx, dword ptr [esp + 0x68]

        $sequence_9 = { e9???????? 488d542468 48c70205000000 e9???????? 488d542468 48c70202000000 eb7d }
            // n = 7, score = 100
            //   e9????????           |                     
            //   488d542468           | mov                 ebx, eax
            //   48c70205000000       | mov                 al, byte ptr [eax]
            //   e9????????           |                     
            //   488d542468           | jmp                 0x116d
            //   48c70202000000       | cmp                 al, 0x25
            //   eb7d                 | jne                 0x1165

    condition:
        7 of them and filesize < 9285632
}