rule win_lumar_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.lumar."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lumar"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7418 8b4514 83c004 894514 8b4514 }
            // n = 5, score = 100
            //   7418                 | je                  0x1a
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   83c004               | add                 eax, 4
            //   894514               | mov                 dword ptr [ebp + 0x14], eax
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]

        $sequence_1 = { 6a68 66898506ffffff 58 6a2f 6689850affffff 58 }
            // n = 6, score = 100
            //   6a68                 | push                0x68
            //   66898506ffffff       | mov                 word ptr [ebp - 0xfa], ax
            //   58                   | pop                 eax
            //   6a2f                 | push                0x2f
            //   6689850affffff       | mov                 word ptr [ebp - 0xf6], ax
            //   58                   | pop                 eax

        $sequence_2 = { 8bd9 03fe e8???????? 3bf8 7604 33c0 }
            // n = 6, score = 100
            //   8bd9                 | mov                 ebx, ecx
            //   03fe                 | add                 edi, esi
            //   e8????????           |                     
            //   3bf8                 | cmp                 edi, eax
            //   7604                 | jbe                 6
            //   33c0                 | xor                 eax, eax

        $sequence_3 = { e8???????? 8b7d08 8b5610 8bca 2b4e0c 0fb7df }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   8b5610               | mov                 edx, dword ptr [esi + 0x10]
            //   8bca                 | mov                 ecx, edx
            //   2b4e0c               | sub                 ecx, dword ptr [esi + 0xc]
            //   0fb7df               | movzx               ebx, di

        $sequence_4 = { 58 6bc005 ff5405b4 6a04 58 6bc007 }
            // n = 6, score = 100
            //   58                   | pop                 eax
            //   6bc005               | imul                eax, eax, 5
            //   ff5405b4             | call                dword ptr [ebp + eax - 0x4c]
            //   6a04                 | push                4
            //   58                   | pop                 eax
            //   6bc007               | imul                eax, eax, 7

        $sequence_5 = { 668945b0 e8???????? 83c414 fe05???????? 8bce e8???????? 8bcb }
            // n = 7, score = 100
            //   668945b0             | mov                 word ptr [ebp - 0x50], ax
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   fe05????????         |                     
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   8bcb                 | mov                 ecx, ebx

        $sequence_6 = { 3bc2 753e 8b4510 85c0 74d3 }
            // n = 5, score = 100
            //   3bc2                 | cmp                 eax, edx
            //   753e                 | jne                 0x40
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   85c0                 | test                eax, eax
            //   74d3                 | je                  0xffffffd5

        $sequence_7 = { 0fb74df8 3bc1 7503 ff65e0 ebd9 }
            // n = 5, score = 100
            //   0fb74df8             | movzx               ecx, word ptr [ebp - 8]
            //   3bc1                 | cmp                 eax, ecx
            //   7503                 | jne                 5
            //   ff65e0               | jmp                 dword ptr [ebp - 0x20]
            //   ebd9                 | jmp                 0xffffffdb

        $sequence_8 = { 0f2805???????? b900010000 53 56 57 }
            // n = 5, score = 100
            //   0f2805????????       |                     
            //   b900010000           | mov                 ecx, 0x100
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi

        $sequence_9 = { 8d842414010000 47 50 57 6a00 c7842420010000a8010000 }
            // n = 6, score = 100
            //   8d842414010000       | lea                 eax, [esp + 0x114]
            //   47                   | inc                 edi
            //   50                   | push                eax
            //   57                   | push                edi
            //   6a00                 | push                0
            //   c7842420010000a8010000     | mov    dword ptr [esp + 0x120], 0x1a8

    condition:
        7 of them and filesize < 81920
}