rule win_lunchmoney_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.lunchmoney."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lunchmoney"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 8d4da8 e8???????? 89759c }
            // n = 4, score = 100
            //   50                   | push                eax
            //   8d4da8               | lea                 ecx, [ebp - 0x58]
            //   e8????????           |                     
            //   89759c               | mov                 dword ptr [ebp - 0x64], esi

        $sequence_1 = { 214610 c7461407000000 668906 68???????? c645fc0b e8???????? }
            // n = 6, score = 100
            //   214610               | and                 dword ptr [esi + 0x10], eax
            //   c7461407000000       | mov                 dword ptr [esi + 0x14], 7
            //   668906               | mov                 word ptr [esi], ax
            //   68????????           |                     
            //   c645fc0b             | mov                 byte ptr [ebp - 4], 0xb
            //   e8????????           |                     

        $sequence_2 = { c1e106 8b048550914200 88540804 8b0f }
            // n = 4, score = 100
            //   c1e106               | shl                 ecx, 6
            //   8b048550914200       | mov                 eax, dword ptr [eax*4 + 0x429150]
            //   88540804             | mov                 byte ptr [eax + ecx + 4], dl
            //   8b0f                 | mov                 ecx, dword ptr [edi]

        $sequence_3 = { 3b4e04 7411 57 8bf8 }
            // n = 4, score = 100
            //   3b4e04               | cmp                 ecx, dword ptr [esi + 4]
            //   7411                 | je                  0x13
            //   57                   | push                edi
            //   8bf8                 | mov                 edi, eax

        $sequence_4 = { 8b9df0efffff 2b7008 037004 6a00 8b049d50914200 5b f644010480 }
            // n = 7, score = 100
            //   8b9df0efffff         | mov                 ebx, dword ptr [ebp - 0x1010]
            //   2b7008               | sub                 esi, dword ptr [eax + 8]
            //   037004               | add                 esi, dword ptr [eax + 4]
            //   6a00                 | push                0
            //   8b049d50914200       | mov                 eax, dword ptr [ebx*4 + 0x429150]
            //   5b                   | pop                 ebx
            //   f644010480           | test                byte ptr [ecx + eax + 4], 0x80

        $sequence_5 = { e9???????? 8365e500 8d45e4 6a0a 50 57 }
            // n = 6, score = 100
            //   e9????????           |                     
            //   8365e500             | and                 dword ptr [ebp - 0x1b], 0
            //   8d45e4               | lea                 eax, [ebp - 0x1c]
            //   6a0a                 | push                0xa
            //   50                   | push                eax
            //   57                   | push                edi

        $sequence_6 = { 8b5584 0500040000 41 3bc2 76f6 8bf1 }
            // n = 6, score = 100
            //   8b5584               | mov                 edx, dword ptr [ebp - 0x7c]
            //   0500040000           | add                 eax, 0x400
            //   41                   | inc                 ecx
            //   3bc2                 | cmp                 eax, edx
            //   76f6                 | jbe                 0xfffffff8
            //   8bf1                 | mov                 esi, ecx

        $sequence_7 = { 83c410 8b048550914200 3b740128 0f85b9010000 3b54012c 0f85af010000 }
            // n = 6, score = 100
            //   83c410               | add                 esp, 0x10
            //   8b048550914200       | mov                 eax, dword ptr [eax*4 + 0x429150]
            //   3b740128             | cmp                 esi, dword ptr [ecx + eax + 0x28]
            //   0f85b9010000         | jne                 0x1bf
            //   3b54012c             | cmp                 edx, dword ptr [ecx + eax + 0x2c]
            //   0f85af010000         | jne                 0x1b5

        $sequence_8 = { e8???????? 83c430 3c01 0f8584000000 83ec18 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   83c430               | add                 esp, 0x30
            //   3c01                 | cmp                 al, 1
            //   0f8584000000         | jne                 0x8a
            //   83ec18               | sub                 esp, 0x18

        $sequence_9 = { 85c0 757c 837dec00 7476 8b55f4 8b049550914200 f644180448 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   757c                 | jne                 0x7e
            //   837dec00             | cmp                 dword ptr [ebp - 0x14], 0
            //   7476                 | je                  0x78
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   8b049550914200       | mov                 eax, dword ptr [edx*4 + 0x429150]
            //   f644180448           | test                byte ptr [eax + ebx + 4], 0x48

    condition:
        7 of them and filesize < 373760
}