rule win_lynx_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.lynx."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lynx"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d4dec 0f1145ec e8???????? b90f000000 8d87bf000000 }
            // n = 5, score = 100
            //   8d4dec               | lea                 ecx, [ebp - 0x14]
            //   0f1145ec             | movups              xmmword ptr [ebp - 0x14], xmm0
            //   e8????????           |                     
            //   b90f000000           | mov                 ecx, 0xf
            //   8d87bf000000         | lea                 eax, [edi + 0xbf]

        $sequence_1 = { 23d1 8b7df4 8bde 8955dc 81f3ffffff03 8b55f0 f7d3 }
            // n = 7, score = 100
            //   23d1                 | and                 edx, ecx
            //   8b7df4               | mov                 edi, dword ptr [ebp - 0xc]
            //   8bde                 | mov                 ebx, esi
            //   8955dc               | mov                 dword ptr [ebp - 0x24], edx
            //   81f3ffffff03         | xor                 ebx, 0x3ffffff
            //   8b55f0               | mov                 edx, dword ptr [ebp - 0x10]
            //   f7d3                 | not                 ebx

        $sequence_2 = { 038580fcffff 038574fdffff 898548fdffff 8d0433 898528fdffff 8b8558fdffff }
            // n = 6, score = 100
            //   038580fcffff         | add                 eax, dword ptr [ebp - 0x380]
            //   038574fdffff         | add                 eax, dword ptr [ebp - 0x28c]
            //   898548fdffff         | mov                 dword ptr [ebp - 0x2b8], eax
            //   8d0433               | lea                 eax, [ebx + esi]
            //   898528fdffff         | mov                 dword ptr [ebp - 0x2d8], eax
            //   8b8558fdffff         | mov                 eax, dword ptr [ebp - 0x2a8]

        $sequence_3 = { e9???????? 83bb6801000000 8b4320 894308 8b4324 c7433400000000 89430c }
            // n = 7, score = 100
            //   e9????????           |                     
            //   83bb6801000000       | cmp                 dword ptr [ebx + 0x168], 0
            //   8b4320               | mov                 eax, dword ptr [ebx + 0x20]
            //   894308               | mov                 dword ptr [ebx + 8], eax
            //   8b4324               | mov                 eax, dword ptr [ebx + 0x24]
            //   c7433400000000       | mov                 dword ptr [ebx + 0x34], 0
            //   89430c               | mov                 dword ptr [ebx + 0xc], eax

        $sequence_4 = { 8d4010 83fa0a 72dc 8b8d0cffffff 2b0f 8b8510ffffff 1b4704 }
            // n = 7, score = 100
            //   8d4010               | lea                 eax, [eax + 0x10]
            //   83fa0a               | cmp                 edx, 0xa
            //   72dc                 | jb                  0xffffffde
            //   8b8d0cffffff         | mov                 ecx, dword ptr [ebp - 0xf4]
            //   2b0f                 | sub                 ecx, dword ptr [edi]
            //   8b8510ffffff         | mov                 eax, dword ptr [ebp - 0xf0]
            //   1b4704               | sbb                 eax, dword ptr [edi + 4]

        $sequence_5 = { ff15???????? 50 ff15???????? 85c0 0f84db000000 8b5dc0 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f84db000000         | je                  0xe1
            //   8b5dc0               | mov                 ebx, dword ptr [ebp - 0x40]

        $sequence_6 = { 41 81f901010000 7ced 8a8619834200 88843319010000 46 81fe00010000 }
            // n = 7, score = 100
            //   41                   | inc                 ecx
            //   81f901010000         | cmp                 ecx, 0x101
            //   7ced                 | jl                  0xffffffef
            //   8a8619834200         | mov                 al, byte ptr [esi + 0x428319]
            //   88843319010000       | mov                 byte ptr [ebx + esi + 0x119], al
            //   46                   | inc                 esi
            //   81fe00010000         | cmp                 esi, 0x100

        $sequence_7 = { 89957cfcffff 899578fcffff 899de4fcffff 81bd3cfdffff80020000 8bbd1cfdffff 89b5e8fcffff 8bb538fdffff }
            // n = 7, score = 100
            //   89957cfcffff         | mov                 dword ptr [ebp - 0x384], edx
            //   899578fcffff         | mov                 dword ptr [ebp - 0x388], edx
            //   899de4fcffff         | mov                 dword ptr [ebp - 0x31c], ebx
            //   81bd3cfdffff80020000     | cmp    dword ptr [ebp - 0x2c4], 0x280
            //   8bbd1cfdffff         | mov                 edi, dword ptr [ebp - 0x2e4]
            //   89b5e8fcffff         | mov                 dword ptr [ebp - 0x318], esi
            //   8bb538fdffff         | mov                 esi, dword ptr [ebp - 0x2c8]

        $sequence_8 = { c1e10e 0b8d28fdffff 318d68fdffff 8b8d74fcffff c1e112 0b8d24fdffff }
            // n = 6, score = 100
            //   c1e10e               | shl                 ecx, 0xe
            //   0b8d28fdffff         | or                  ecx, dword ptr [ebp - 0x2d8]
            //   318d68fdffff         | xor                 dword ptr [ebp - 0x298], ecx
            //   8b8d74fcffff         | mov                 ecx, dword ptr [ebp - 0x38c]
            //   c1e112               | shl                 ecx, 0x12
            //   0b8d24fdffff         | or                  ecx, dword ptr [ebp - 0x2dc]

        $sequence_9 = { ff750c 57 6a01 53 ff15???????? 50 53 }
            // n = 7, score = 100
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   57                   | push                edi
            //   6a01                 | push                1
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   50                   | push                eax
            //   53                   | push                ebx

    condition:
        7 of them and filesize < 363520
}