rule win_lyposit_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.lyposit."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lyposit"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 68???????? e8???????? 8b5d10 8365fc00 6a1c 6a40 ff15???????? }
            // n = 7, score = 200
            //   68????????           |                     
            //   e8????????           |                     
            //   8b5d10               | mov                 ebx, dword ptr [ebp + 0x10]
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   6a1c                 | push                0x1c
            //   6a40                 | push                0x40
            //   ff15????????         |                     

        $sequence_1 = { 53 ff15???????? 85c0 742a 6aff ff75c0 ff15???????? }
            // n = 7, score = 200
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   742a                 | je                  0x2c
            //   6aff                 | push                -1
            //   ff75c0               | push                dword ptr [ebp - 0x40]
            //   ff15????????         |                     

        $sequence_2 = { 83c410 85c0 7424 8b4ddc 8a01 3c31 7504 }
            // n = 7, score = 200
            //   83c410               | add                 esp, 0x10
            //   85c0                 | test                eax, eax
            //   7424                 | je                  0x26
            //   8b4ddc               | mov                 ecx, dword ptr [ebp - 0x24]
            //   8a01                 | mov                 al, byte ptr [ecx]
            //   3c31                 | cmp                 al, 0x31
            //   7504                 | jne                 6

        $sequence_3 = { 8b0f e8???????? 59 59 0337 }
            // n = 5, score = 200
            //   8b0f                 | mov                 ecx, dword ptr [edi]
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   0337                 | add                 esi, dword ptr [edi]

        $sequence_4 = { 52 50 ff91d0000000 8d45e4 50 ff15???????? ebd3 }
            // n = 7, score = 200
            //   52                   | push                edx
            //   50                   | push                eax
            //   ff91d0000000         | call                dword ptr [ecx + 0xd0]
            //   8d45e4               | lea                 eax, [ebp - 0x1c]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   ebd3                 | jmp                 0xffffffd5

        $sequence_5 = { 66a3???????? 8be5 5d c3 6a14 68???????? e8???????? }
            // n = 7, score = 200
            //   66a3????????         |                     
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   6a14                 | push                0x14
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_6 = { 84d2 7407 838b0c02000020 807dff00 7407 }
            // n = 5, score = 200
            //   84d2                 | test                dl, dl
            //   7407                 | je                  9
            //   838b0c02000020       | or                  dword ptr [ebx + 0x20c], 0x20
            //   807dff00             | cmp                 byte ptr [ebp - 1], 0
            //   7407                 | je                  9

        $sequence_7 = { ff75e4 ff7604 ff36 ff7508 e8???????? }
            // n = 5, score = 200
            //   ff75e4               | push                dword ptr [ebp - 0x1c]
            //   ff7604               | push                dword ptr [esi + 4]
            //   ff36                 | push                dword ptr [esi]
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     

        $sequence_8 = { 8b45fc ebd0 53 55 33db 33ed }
            // n = 6, score = 200
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   ebd0                 | jmp                 0xffffffd2
            //   53                   | push                ebx
            //   55                   | push                ebp
            //   33db                 | xor                 ebx, ebx
            //   33ed                 | xor                 ebp, ebp

        $sequence_9 = { ff75e4 ff15???????? 85c0 7425 6a0b 56 ff75d8 }
            // n = 7, score = 200
            //   ff75e4               | push                dword ptr [ebp - 0x1c]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7425                 | je                  0x27
            //   6a0b                 | push                0xb
            //   56                   | push                esi
            //   ff75d8               | push                dword ptr [ebp - 0x28]

    condition:
        7 of them and filesize < 466944
}