rule win_m0yv_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.m0yv."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.m0yv"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4589d1 41c1f919 4501c1 4589c8 41c1f81a 4501d8 8811 }
            // n = 7, score = 100
            //   4589d1               | dec                 esp
            //   41c1f919             | mov                 dword ptr [esp + 8], ebx
            //   4501c1               | dec                 ebp
            //   4589c8               | imul                edx, edi
            //   41c1f81a             | dec                 ebp
            //   4501d8               | imul                ecx, edi
            //   8811                 | dec                 esp

        $sequence_1 = { 4889ce e8???????? 31ff 4885db 744f 85c0 744b }
            // n = 7, score = 100
            //   4889ce               | mov                 eax, dword ptr [ebp + 8]
            //   e8????????           |                     
            //   31ff                 | mov                 eax, dword ptr [eax + 8]
            //   4885db               | add                 eax, -1
            //   744f                 | dec                 ecx
            //   85c0                 | cmp                 edi, eax
            //   744b                 | test                eax, eax

        $sequence_2 = { 7418 4180783c02 755f 418ac3 24f0 3c40 7556 }
            // n = 7, score = 100
            //   7418                 | xor                 ebx, eax
            //   4180783c02           | mov                 dword ptr [esp + esi*4 + 0x1004], ebx
            //   755f                 | dec                 eax
            //   418ac3               | add                 esi, 2
            //   24f0                 | inc                 esp
            //   3c40                 | xor                 ebp, edi
            //   7556                 | dec                 eax

        $sequence_3 = { 4801d8 480500000001 4803542420 4889c5 }
            // n = 4, score = 100
            //   4801d8               | xor                 al, byte ptr [ecx + 0x1d]
            //   480500000001         | inc                 esp
            //   4803542420           | or                  al, dl
            //   4889c5               | inc                 esp

        $sequence_4 = { b918000000 ff10 4885c0 740b c70002000000 897008 eb02 }
            // n = 7, score = 100
            //   b918000000           | dec                 eax
            //   ff10                 | imul                edi, dword ptr [esp + 0x10]
            //   4885c0               | dec                 eax
            //   740b                 | add                 ecx, edi
            //   c70002000000         | dec                 esp
            //   897008               | mov                 edi, edi
            //   eb02                 | dec                 ecx

        $sequence_5 = { 4d89ea 4a035cee08 4831cf 4889c1 48c1c11e 4889c6 4931fc }
            // n = 7, score = 100
            //   4d89ea               | inc                 ecx
            //   4a035cee08           | mov                 byte ptr [eax + 0x5f], bh
            //   4831cf               | inc                 ecx
            //   4889c1               | mov                 byte ptr [eax + 0x5e], ch
            //   48c1c11e             | inc                 ebp
            //   4889c6               | test                cl, cl
            //   4931fc               | je                  0x2a3

        $sequence_6 = { 4889f2 e8???????? 4c89e1 4c89e2 4989d8 e8???????? 4c8d4778 }
            // n = 7, score = 100
            //   4889f2               | movsx               ebp, byte ptr [esi + ecx]
            //   e8????????           |                     
            //   4c89e1               | test                ebp, ebp
            //   4c89e2               | je                  0x38b
            //   4989d8               | lea                 ecx, [ebp - 9]
            //   e8????????           |                     
            //   4c8d4778             | cmp                 ecx, 0x54

        $sequence_7 = { 4869c2182d0700 4901c3 4c69d5d1150200 4d01fa 4869c267fb0900 }
            // n = 5, score = 100
            //   4869c2182d0700       | shr                 edi, cl
            //   4901c3               | inc                 ecx
            //   4c69d5d1150200       | and                 edi, 1
            //   4d01fa               | inc                 esp
            //   4869c267fb0900       | movzx               eax, byte ptr [ecx + 0xa6]

        $sequence_8 = { 4889dd 480fafee 4889ac2488000000 4c8d3c36 480faff6 4801ce 48635810 }
            // n = 7, score = 100
            //   4889dd               | and                 edx, 0x1fffff
            //   480fafee             | dec                 eax
            //   4889ac2488000000     | shr                 ebp, 6
            //   4c8d3c36             | inc                 eax
            //   480faff6             | mov                 byte ptr [edi + 6], ch
            //   4801ce               | mov                 esi, edx
            //   48635810             | mov                 byte ptr [edi + 0xa], dl

        $sequence_9 = { b918000000 ff17 4885c0 7433 4889c6 c70006000000 }
            // n = 6, score = 100
            //   b918000000           | dec                 eax
            //   ff17                 | mov                 ecx, eax
            //   4885c0               | dec                 eax
            //   7433                 | lea                 edx, [0x15c50]
            //   4889c6               | dec                 ecx
            //   c70006000000         | cmp                 edi, ecx

    condition:
        7 of them and filesize < 779264
}