rule win_madmax_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.madmax."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.madmax"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { f605????????5a 0f85ea000000 95 8883424ceb3e 38af847bb313 8320aa d590 }
            // n = 7, score = 100
            //   f605????????5a       |                     
            //   0f85ea000000         | jne                 0xf0
            //   95                   | xchg                eax, ebp
            //   8883424ceb3e         | mov                 byte ptr [ebx + 0x3eeb4c42], al
            //   38af847bb313         | cmp                 byte ptr [edi + 0x13b37b84], ch
            //   8320aa               | and                 dword ptr [eax], 0xffffffaa
            //   d590                 | aad                 0x90

        $sequence_1 = { fa 768b 872a fd 2a4f0e e8???????? b3df }
            // n = 7, score = 100
            //   fa                   | cli                 
            //   768b                 | jbe                 0xffffff8d
            //   872a                 | xchg                dword ptr [edx], ebp
            //   fd                   | std                 
            //   2a4f0e               | sub                 cl, byte ptr [edi + 0xe]
            //   e8????????           |                     
            //   b3df                 | mov                 bl, 0xdf

        $sequence_2 = { af 2f ac 7cd6 45 98 92 }
            // n = 7, score = 100
            //   af                   | scasd               eax, dword ptr es:[edi]
            //   2f                   | das                 
            //   ac                   | lodsb               al, byte ptr [esi]
            //   7cd6                 | jl                  0xffffffd8
            //   45                   | inc                 ebp
            //   98                   | cwde                
            //   92                   | xchg                eax, edx

        $sequence_3 = { bf45f19eb2 ac a5 d6 34e2 1117 4c }
            // n = 7, score = 100
            //   bf45f19eb2           | mov                 edi, 0xb29ef145
            //   ac                   | lodsb               al, byte ptr [esi]
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   d6                   | salc                
            //   34e2                 | xor                 al, 0xe2
            //   1117                 | adc                 dword ptr [edi], edx
            //   4c                   | dec                 esp

        $sequence_4 = { e6d1 f5 9f 45 7b78 39770f d0de }
            // n = 7, score = 100
            //   e6d1                 | out                 0xd1, al
            //   f5                   | cmc                 
            //   9f                   | lahf                
            //   45                   | inc                 ebp
            //   7b78                 | jnp                 0x7a
            //   39770f               | cmp                 dword ptr [edi + 0xf], esi
            //   d0de                 | rcr                 dh, 1

        $sequence_5 = { b4bf 49 95 14c0 393f d8d3 fc }
            // n = 7, score = 100
            //   b4bf                 | mov                 ah, 0xbf
            //   49                   | dec                 ecx
            //   95                   | xchg                eax, ebp
            //   14c0                 | adc                 al, 0xc0
            //   393f                 | cmp                 dword ptr [edi], edi
            //   d8d3                 | fcom                st(3)
            //   fc                   | cld                 

        $sequence_6 = { 7135 fd 9e 9d 50 50 9c }
            // n = 7, score = 100
            //   7135                 | jno                 0x37
            //   fd                   | std                 
            //   9e                   | sahf                
            //   9d                   | popfd               
            //   50                   | push                eax
            //   50                   | push                eax
            //   9c                   | pushfd              

        $sequence_7 = { c9 09f8 96 67a4 61 52 636e85 }
            // n = 7, score = 100
            //   c9                   | leave               
            //   09f8                 | or                  eax, edi
            //   96                   | xchg                eax, esi
            //   67a4                 | movsb               byte ptr es:[di], byte ptr [si]
            //   61                   | popal               
            //   52                   | push                edx
            //   636e85               | arpl                word ptr [esi - 0x7b], bp

        $sequence_8 = { 9d 53 6a03 e8???????? 83c40c 9c f605????????e8 }
            // n = 7, score = 100
            //   9d                   | popfd               
            //   53                   | push                ebx
            //   6a03                 | push                3
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   9c                   | pushfd              
            //   f605????????e8       |                     

        $sequence_9 = { be492ea060 c14434e19e 46 2f d3f4 fa 6be92a }
            // n = 7, score = 100
            //   be492ea060           | mov                 esi, 0x60a02e49
            //   c14434e19e           | rol                 dword ptr [esp + esi - 0x1f], 0x9e
            //   46                   | inc                 esi
            //   2f                   | das                 
            //   d3f4                 | sal                 esp, cl
            //   fa                   | cli                 
            //   6be92a               | imul                ebp, ecx, 0x2a

    condition:
        7 of them and filesize < 3227648
}