rule win_magala_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.magala."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.magala"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 57 8d0451 e9???????? 8b4614 3bf7 746d }
            // n = 7, score = 200
            //   50                   | push                eax
            //   57                   | push                edi
            //   8d0451               | lea                 eax, [ecx + edx*2]
            //   e9????????           |                     
            //   8b4614               | mov                 eax, dword ptr [esi + 0x14]
            //   3bf7                 | cmp                 esi, edi
            //   746d                 | je                  0x6f

        $sequence_1 = { c745ec07000000 668945d8 e8???????? 837dec08 8d4dc4 6a04 51 }
            // n = 7, score = 200
            //   c745ec07000000       | mov                 dword ptr [ebp - 0x14], 7
            //   668945d8             | mov                 word ptr [ebp - 0x28], ax
            //   e8????????           |                     
            //   837dec08             | cmp                 dword ptr [ebp - 0x14], 8
            //   8d4dc4               | lea                 ecx, [ebp - 0x3c]
            //   6a04                 | push                4
            //   51                   | push                ecx

        $sequence_2 = { 50 8d8dd0fdffff e8???????? 6a1f 68???????? }
            // n = 5, score = 200
            //   50                   | push                eax
            //   8d8dd0fdffff         | lea                 ecx, [ebp - 0x230]
            //   e8????????           |                     
            //   6a1f                 | push                0x1f
            //   68????????           |                     

        $sequence_3 = { 8da5f4feffff 8b4df4 64890d00000000 59 5f }
            // n = 5, score = 200
            //   8da5f4feffff         | lea                 esp, [ebp - 0x10c]
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx
            //   59                   | pop                 ecx
            //   5f                   | pop                 edi

        $sequence_4 = { 83bd8cfdffff00 7435 51 8d8d94fdffff e8???????? }
            // n = 5, score = 200
            //   83bd8cfdffff00       | cmp                 dword ptr [ebp - 0x274], 0
            //   7435                 | je                  0x37
            //   51                   | push                ecx
            //   8d8d94fdffff         | lea                 ecx, [ebp - 0x26c]
            //   e8????????           |                     

        $sequence_5 = { e8???????? 83c404 ffd6 2bc7 3de0930400 76cf 68???????? }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   ffd6                 | call                esi
            //   2bc7                 | sub                 eax, edi
            //   3de0930400           | cmp                 eax, 0x493e0
            //   76cf                 | jbe                 0xffffffd1
            //   68????????           |                     

        $sequence_6 = { 56 8bf1 8b4e10 3bca 0f8214020000 8b450c 53 }
            // n = 7, score = 200
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   8b4e10               | mov                 ecx, dword ptr [esi + 0x10]
            //   3bca                 | cmp                 ecx, edx
            //   0f8214020000         | jb                  0x21a
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   53                   | push                ebx

        $sequence_7 = { c745c000000000 8b08 50 ff5108 8b45b8 8d55c0 }
            // n = 6, score = 200
            //   c745c000000000       | mov                 dword ptr [ebp - 0x40], 0
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   50                   | push                eax
            //   ff5108               | call                dword ptr [ecx + 8]
            //   8b45b8               | mov                 eax, dword ptr [ebp - 0x48]
            //   8d55c0               | lea                 edx, [ebp - 0x40]

        $sequence_8 = { 6a00 8bcf e8???????? 8b4db4 85c9 7444 ff75b0 }
            // n = 7, score = 200
            //   6a00                 | push                0
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   8b4db4               | mov                 ecx, dword ptr [ebp - 0x4c]
            //   85c9                 | test                ecx, ecx
            //   7444                 | je                  0x46
            //   ff75b0               | push                dword ptr [ebp - 0x50]

        $sequence_9 = { 85db 744e 8bcb 8d5101 6690 8a01 }
            // n = 6, score = 200
            //   85db                 | test                ebx, ebx
            //   744e                 | je                  0x50
            //   8bcb                 | mov                 ecx, ebx
            //   8d5101               | lea                 edx, [ecx + 1]
            //   6690                 | nop                 
            //   8a01                 | mov                 al, byte ptr [ecx]

    condition:
        7 of them and filesize < 589824
}