rule win_maggie_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.maggie."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.maggie"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? e8???????? 84c0 74ec e8???????? }
            // n = 5, score = 300
            //   ff15????????         |                     
            //   e8????????           |                     
            //   84c0                 | cmp                 cx, ax
            //   74ec                 | jne                 0x97f
            //   e8????????           |                     

        $sequence_1 = { ff15???????? 83f8ff 750f ff15???????? 2d33270000 }
            // n = 5, score = 300
            //   ff15????????         |                     
            //   83f8ff               | mov                 ecx, dword ptr [ebx]
            //   750f                 | jmp                 0x18bf
            //   ff15????????         |                     
            //   2d33270000           | pop                 esi

        $sequence_2 = { 663b05???????? 7505 e8???????? e8???????? }
            // n = 4, score = 300
            //   663b05????????       |                     
            //   7505                 | lea                 ecx, [0x386f5]
            //   e8????????           |                     
            //   e8????????           |                     

        $sequence_3 = { 7511 ff15???????? 85c0 7407 33c0 e9???????? }
            // n = 6, score = 300
            //   7511                 | inc                 ebp
            //   ff15????????         |                     
            //   85c0                 | xor                 eax, eax
            //   7407                 | inc                 eax
            //   33c0                 | cmp                 al, dh
            //   e9????????           |                     

        $sequence_4 = { b8ff000000 663b05???????? 7505 e8???????? }
            // n = 4, score = 300
            //   b8ff000000           | jae                 0x1999
            //   663b05????????       |                     
            //   7505                 | dec                 eax
            //   e8????????           |                     

        $sequence_5 = { 750f ff15???????? 2d33270000 f7d8 }
            // n = 4, score = 300
            //   750f                 | not                 ecx
            //   ff15????????         |                     
            //   2d33270000           | dec                 eax
            //   f7d8                 | cmp                 ecx, 1

        $sequence_6 = { 750f ff15???????? 2d33270000 f7d8 1bc0 }
            // n = 5, score = 300
            //   750f                 | mov                 dword ptr [esp + 0x20], eax
            //   ff15????????         |                     
            //   2d33270000           | inc                 ebp
            //   f7d8                 | xor                 ecx, ecx
            //   1bc0                 | dec                 esp

        $sequence_7 = { 663b05???????? 7505 e8???????? e8???????? 84c0 }
            // n = 5, score = 300
            //   663b05????????       |                     
            //   7505                 | dec                 eax
            //   e8????????           |                     
            //   e8????????           |                     
            //   84c0                 | mov                 esi, dword ptr [esp + 0x58]

        $sequence_8 = { 83f8ff 750f ff15???????? 2d33270000 f7d8 1bc0 }
            // n = 6, score = 300
            //   83f8ff               | test                ecx, ecx
            //   750f                 | je                  0x131
            //   ff15????????         |                     
            //   2d33270000           | jne                 0xe1
            //   f7d8                 | dec                 eax
            //   1bc0                 | sub                 esp, 0x20

        $sequence_9 = { ff15???????? 83f8ff 750f ff15???????? 2d33270000 f7d8 }
            // n = 6, score = 300
            //   ff15????????         |                     
            //   83f8ff               | dec                 eax
            //   750f                 | mov                 edi, edx
            //   ff15????????         |                     
            //   2d33270000           | xor                 eax, eax
            //   f7d8                 | mov                 byte ptr [esp + 0xc0], 0

    condition:
        7 of them and filesize < 611328
}