rule win_magniber_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.magniber."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.magniber"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c78514fdffff38994000 c78518fdffff40994000 c7851cfdffff48994000 c78520fdffff54994000 c78524fdffff60994000 c78528fdffff68994000 }
            // n = 6, score = 400
            //   c78514fdffff38994000     | mov    dword ptr [ebp - 0x2ec], 0x409938
            //   c78518fdffff40994000     | mov    dword ptr [ebp - 0x2e8], 0x409940
            //   c7851cfdffff48994000     | mov    dword ptr [ebp - 0x2e4], 0x409948
            //   c78520fdffff54994000     | mov    dword ptr [ebp - 0x2e0], 0x409954
            //   c78524fdffff60994000     | mov    dword ptr [ebp - 0x2dc], 0x409960
            //   c78528fdffff68994000     | mov    dword ptr [ebp - 0x2d8], 0x409968

        $sequence_1 = { 83c404 8945fc 837dfc00 0f84d7000000 68???????? 8b45fc }
            // n = 6, score = 400
            //   83c404               | add                 esp, 4
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   837dfc00             | cmp                 dword ptr [ebp - 4], 0
            //   0f84d7000000         | je                  0xdd
            //   68????????           |                     
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

        $sequence_2 = { 8b45f8 8b8c8548ffffff 51 8b55f0 52 }
            // n = 5, score = 400
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   8b8c8548ffffff       | mov                 ecx, dword ptr [ebp + eax*4 - 0xb8]
            //   51                   | push                ecx
            //   8b55f0               | mov                 edx, dword ptr [ebp - 0x10]
            //   52                   | push                edx

        $sequence_3 = { 0f8462010000 8b55ec 52 ff15???????? 83f801 }
            // n = 5, score = 400
            //   0f8462010000         | je                  0x168
            //   8b55ec               | mov                 edx, dword ptr [ebp - 0x14]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   83f801               | cmp                 eax, 1

        $sequence_4 = { c785fcfcffff08994000 c78500fdffff10994000 c78504fdffff18994000 c78508fdffff20994000 c7850cfdffff28994000 c78510fdffff30994000 }
            // n = 6, score = 400
            //   c785fcfcffff08994000     | mov    dword ptr [ebp - 0x304], 0x409908
            //   c78500fdffff10994000     | mov    dword ptr [ebp - 0x300], 0x409910
            //   c78504fdffff18994000     | mov    dword ptr [ebp - 0x2fc], 0x409918
            //   c78508fdffff20994000     | mov    dword ptr [ebp - 0x2f8], 0x409920
            //   c7850cfdffff28994000     | mov    dword ptr [ebp - 0x2f4], 0x409928
            //   c78510fdffff30994000     | mov    dword ptr [ebp - 0x2f0], 0x409930

        $sequence_5 = { 7505 e9???????? 8b4df8 3b4df0 7307 }
            // n = 5, score = 400
            //   7505                 | jne                 7
            //   e9????????           |                     
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   3b4df0               | cmp                 ecx, dword ptr [ebp - 0x10]
            //   7307                 | jae                 9

        $sequence_6 = { 6a00 6a03 6800000080 8b4d10 51 }
            // n = 5, score = 400
            //   6a00                 | push                0
            //   6a03                 | push                3
            //   6800000080           | push                0x80000000
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   51                   | push                ecx

        $sequence_7 = { 55 8bec 51 8b4508 83b86804000000 741b 8b4d08 }
            // n = 7, score = 400
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   51                   | push                ecx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   83b86804000000       | cmp                 dword ptr [eax + 0x468], 0
            //   741b                 | je                  0x1d
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]

        $sequence_8 = { d331 4e4e54 70ac 52 f8 a6 }
            // n = 6, score = 100
            //   d331                 | dec                 ebx
            //   4e4e54               | stosb               byte ptr es:[edi], al
            //   70ac                 | add                 eax, 0x1d545754
            //   52                   | mov                 esp, 0x87978112
            //   f8                   | mov                 ebx, 0x73d481dd
            //   a6                   | sal                 dword ptr [ecx], cl

        $sequence_9 = { 097934 50 5e 5a 3558e9e633 }
            // n = 5, score = 100
            //   097934               | dec                 eax
            //   50                   | xor                 al, 0xb0
            //   5e                   | sbb                 byte ptr [eax + 0x26], al
            //   5a                   | loop                0x29
            //   3558e9e633           | or                  dword ptr [ecx + 0x34], edi

        $sequence_10 = { bb72657959 a1????????ba30f7a3 873428 de9d164df944 ee aa }
            // n = 6, score = 100
            //   bb72657959           | clc                 
            //   a1????????ba30f7a3     |     
            //   873428               | cmpsb               byte ptr [esi], byte ptr es:[edi]
            //   de9d164df944         | sbb                 byte ptr [eax + 0x26], al
            //   ee                   | loop                0x23
            //   aa                   | loopne              0xfffffffc

        $sequence_11 = { 7f4c c82cd1c6 1a32 b636 }
            // n = 4, score = 100
            //   7f4c                 | std                 
            //   c82cd1c6             | push                -0x35
            //   1a32                 | sbb                 dword ptr [ebx + 0x62236335], edx
            //   b636                 | mov                 esp, 0x87978112

        $sequence_12 = { 21746c2e 4834b0 184026 e221 a1????????05eef081 e0f8 }
            // n = 6, score = 100
            //   21746c2e             | mov                 edx, 0x5dc2623
            //   4834b0               | pop                 edi
            //   184026               | and                 dword ptr [esp + ebp*2 + 0x2e], esi
            //   e221                 | dec                 eax
            //   a1????????05eef081     |     
            //   e0f8                 | xor                 al, 0xb0

        $sequence_13 = { 4baa 055457541d e9???????? bc12819787 bbdd81d473 ba2326dc05 645f }
            // n = 7, score = 100
            //   4baa                 | sbb                 byte ptr [eax + 0x26], al
            //   055457541d           | dec                 ebx
            //   e9????????           |                     
            //   bc12819787           | stosb               byte ptr es:[edi], al
            //   bbdd81d473           | add                 eax, 0x1d545754
            //   ba2326dc05           | mov                 esp, 0x87978112
            //   645f                 | mov                 ebx, 0x73d481dd

        $sequence_14 = { 32cb 5a b3b1 3e6c 21746c2e 4834b0 184026 }
            // n = 7, score = 100
            //   32cb                 | xor                 cl, bl
            //   5a                   | pop                 edx
            //   b3b1                 | mov                 bl, 0xb1
            //   3e6c                 | insb                byte ptr es:[edi], dx
            //   21746c2e             | and                 dword ptr [esp + ebp*2 + 0x2e], esi
            //   4834b0               | dec                 eax
            //   184026               | xor                 al, 0xb0

        $sequence_15 = { 283d98b7a0e5 7f9b 0b733e fd 6acb 199335632362 }
            // n = 6, score = 100
            //   283d98b7a0e5         | sub                 dword ptr [esi - 0x59a0ae30], ebp
            //   7f9b                 | lea                 ecx, [edi + 0xe]
            //   0b733e               | mov                 ebx, 0x59796572
            //   fd                   | xchg                dword ptr [eax + ebp], esi
            //   6acb                 | ficomp              word ptr [ebp + 0x44f94d16]
            //   199335632362         | out                 dx, al

    condition:
        7 of them and filesize < 117760
}