rule win_mail_o_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mail_o."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mail_o"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb09 b801000000 66894348 ba03000000 897320 488d8b70010000 e8???????? }
            // n = 7, score = 100
            //   eb09                 | lea                 eax, [esp + 0x30]
            //   b801000000           | dec                 eax
            //   66894348             | mov                 edi, eax
            //   ba03000000           | dec                 eax
            //   897320               | test                eax, eax
            //   488d8b70010000       | jne                 0x794
            //   e8????????           |                     

        $sequence_1 = { c781e806000002000000 b801000000 4883c438 c3 c744242892070000 ba2f000000 41b96e000000 }
            // n = 7, score = 100
            //   c781e806000002000000     | dec    eax
            //   b801000000           | mov                 ecx, dword ptr [ecx + 0x90]
            //   4883c438             | dec                 eax
            //   c3                   | mov                 dword ptr [esp + 0x58], esi
            //   c744242892070000     | dec                 eax
            //   ba2f000000           | mov                 eax, dword ptr [ebx]
            //   41b96e000000         | inc                 ebp

        $sequence_2 = { eba9 488b5008 4c8d442440 488d0debe00e00 488b5208 e8???????? eb8e }
            // n = 7, score = 100
            //   eba9                 | dec                 eax
            //   488b5008             | lea                 eax, [0x128ebd]
            //   4c8d442440           | inc                 ecx
            //   488d0debe00e00       | mov                 eax, 0x1ce
            //   488b5208             | dec                 eax
            //   e8????????           |                     
            //   eb8e                 | mov                 ecx, edi

        $sequence_3 = { b800010000 e8???????? 482be0 488b05???????? 4833c4 48898424d0000000 4c8ba42450010000 }
            // n = 7, score = 100
            //   b800010000           | mov                 eax, eax
            //   e8????????           |                     
            //   482be0               | dec                 eax
            //   488b05????????       |                     
            //   4833c4               | lea                 esi, [esp + 0x20]
            //   48898424d0000000     | dec                 eax
            //   4c8ba42450010000     | and                 eax, 0xfffffffe

        $sequence_4 = { e8???????? 8bf0 83f8ff 0f85befeffff 33c0 488b5c2470 488b6c2478 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8bf0                 | imul                eax, dword ptr [esp + 0x18]
            //   83f8ff               | dec                 eax
            //   0f85befeffff         | add                 ebx, eax
            //   33c0                 | dec                 eax
            //   488b5c2470           | mov                 edx, ebp
            //   488b6c2478           | dec                 eax

        $sequence_5 = { 74bb 488d8b00080000 e8???????? 85c0 7457 488b9388000000 488bcb }
            // n = 7, score = 100
            //   74bb                 | dec                 eax
            //   488d8b00080000       | add                 dword ptr [ebp + 0x28], eax
            //   e8????????           |                     
            //   85c0                 | dec                 ecx
            //   7457                 | mov                 eax, ebp
            //   488b9388000000       | dec                 eax
            //   488bcb               | sub                 eax, dword ptr [ebp - 0x20]

        $sequence_6 = { eb04 488b45d8 8b0a 4d8bfe 8bc0 498bd5 4c8b6da8 }
            // n = 7, score = 100
            //   eb04                 | mov                 esi, ecx
            //   488b45d8             | dec                 eax
            //   8b0a                 | test                edx, edx
            //   4d8bfe               | je                  0x10f4
            //   8bc0                 | xor                 edi, edi
            //   498bd5               | dec                 eax
            //   4c8b6da8             | lea                 ebx, [0x129cda]

        $sequence_7 = { 85c0 0f8ec7000000 0f1f4000 488b8bf8000000 8bd5 e8???????? 488bf0 }
            // n = 7, score = 100
            //   85c0                 | sub                 esp, eax
            //   0f8ec7000000         | dec                 eax
            //   0f1f4000             | mov                 edi, ecx
            //   488b8bf8000000       | dec                 eax
            //   8bd5                 | test                ecx, ecx
            //   e8????????           |                     
            //   488bf0               | je                  0x749

        $sequence_8 = { c744242073000000 4c8d0d028e1100 8d4f06 448d420b e8???????? 33c0 488b5c2440 }
            // n = 7, score = 100
            //   c744242073000000     | test                eax, eax
            //   4c8d0d028e1100       | je                  0xa9e
            //   8d4f06               | nop                 dword ptr [eax + eax]
            //   448d420b             | dec                 eax
            //   e8????????           |                     
            //   33c0                 | mov                 edi, dword ptr [edi + 8]
            //   488b5c2440           | xor                 ebx, ebx

        $sequence_9 = { eb1a 488bcb e8???????? 85c0 7560 4889b3500d0000 4889b350160000 }
            // n = 7, score = 100
            //   eb1a                 | mov                 eax, dword ptr [edx + 0x2c]
            //   488bcb               | dec                 ecx
            //   e8????????           |                     
            //   85c0                 | add                 eax, 0x28
            //   7560                 | dec                 eax
            //   4889b3500d0000       | mov                 edi, edx
            //   4889b350160000       | movzx               esi, byte ptr [esp + 0x60]

    condition:
        7 of them and filesize < 5985280
}