rule win_mailto_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mailto."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mailto"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 57 e8???????? 56 ffb42498050000 8d8424e8010000 50 }
            // n = 6, score = 400
            //   57                   | push                edi
            //   e8????????           |                     
            //   56                   | push                esi
            //   ffb42498050000       | push                dword ptr [esp + 0x598]
            //   8d8424e8010000       | lea                 eax, [esp + 0x1e8]
            //   50                   | push                eax

        $sequence_1 = { 8bce d1ee 83e101 f7d9 81e12083b8ed 33ce 8bd1 }
            // n = 7, score = 400
            //   8bce                 | mov                 ecx, esi
            //   d1ee                 | shr                 esi, 1
            //   83e101               | and                 ecx, 1
            //   f7d9                 | neg                 ecx
            //   81e12083b8ed         | and                 ecx, 0xedb88320
            //   33ce                 | xor                 ecx, esi
            //   8bd1                 | mov                 edx, ecx

        $sequence_2 = { 7434 a1???????? 8d048504000000 50 ff35???????? e8???????? 83c408 }
            // n = 7, score = 400
            //   7434                 | je                  0x36
            //   a1????????           |                     
            //   8d048504000000       | lea                 eax, [eax*4 + 4]
            //   50                   | push                eax
            //   ff35????????         |                     
            //   e8????????           |                     
            //   83c408               | add                 esp, 8

        $sequence_3 = { b938000000 8d3c32 2bca 33c0 8bd1 c1e902 f3ab }
            // n = 7, score = 400
            //   b938000000           | mov                 ecx, 0x38
            //   8d3c32               | lea                 edi, [edx + esi]
            //   2bca                 | sub                 ecx, edx
            //   33c0                 | xor                 eax, eax
            //   8bd1                 | mov                 edx, ecx
            //   c1e902               | shr                 ecx, 2
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax

        $sequence_4 = { 47 ff742418 897c2420 6a03 e8???????? 8bf0 }
            // n = 6, score = 400
            //   47                   | inc                 edi
            //   ff742418             | push                dword ptr [esp + 0x18]
            //   897c2420             | mov                 dword ptr [esp + 0x20], edi
            //   6a03                 | push                3
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_5 = { 83c614 ff36 e8???????? 83c404 8d7620 83ed01 75ee }
            // n = 7, score = 400
            //   83c614               | add                 esi, 0x14
            //   ff36                 | push                dword ptr [esi]
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8d7620               | lea                 esi, [esi + 0x20]
            //   83ed01               | sub                 ebp, 1
            //   75ee                 | jne                 0xfffffff0

        $sequence_6 = { 8d4010 0f104406f0 660fefc1 0f1140f0 83e901 75eb }
            // n = 6, score = 400
            //   8d4010               | lea                 eax, [eax + 0x10]
            //   0f104406f0           | movups              xmm0, xmmword ptr [esi + eax - 0x10]
            //   660fefc1             | pxor                xmm0, xmm1
            //   0f1140f0             | movups              xmmword ptr [eax - 0x10], xmm0
            //   83e901               | sub                 ecx, 1
            //   75eb                 | jne                 0xffffffed

        $sequence_7 = { 6a00 6a02 ffd0 85c0 0f8517020000 53 55 }
            // n = 7, score = 400
            //   6a00                 | push                0
            //   6a02                 | push                2
            //   ffd0                 | call                eax
            //   85c0                 | test                eax, eax
            //   0f8517020000         | jne                 0x21d
            //   53                   | push                ebx
            //   55                   | push                ebp

        $sequence_8 = { 0f1f4000 8b840c54030000 01440c0c 8b840c58030000 11440c10 8b840c5c030000 01440c14 }
            // n = 7, score = 400
            //   0f1f4000             | nop                 dword ptr [eax]
            //   8b840c54030000       | mov                 eax, dword ptr [esp + ecx + 0x354]
            //   01440c0c             | add                 dword ptr [esp + ecx + 0xc], eax
            //   8b840c58030000       | mov                 eax, dword ptr [esp + ecx + 0x358]
            //   11440c10             | adc                 dword ptr [esp + ecx + 0x10], eax
            //   8b840c5c030000       | mov                 eax, dword ptr [esp + ecx + 0x35c]
            //   01440c14             | add                 dword ptr [esp + ecx + 0x14], eax

        $sequence_9 = { d1ea 83e101 f7d9 81e12083b8ed 33ca 8bd1 d1e9 }
            // n = 7, score = 400
            //   d1ea                 | shr                 edx, 1
            //   83e101               | and                 ecx, 1
            //   f7d9                 | neg                 ecx
            //   81e12083b8ed         | and                 ecx, 0xedb88320
            //   33ca                 | xor                 ecx, edx
            //   8bd1                 | mov                 edx, ecx
            //   d1e9                 | shr                 ecx, 1

    condition:
        7 of them and filesize < 180224
}