rule win_makadocs_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.makadocs."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.makadocs"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 e8???????? 83c414 8d5c2414 c644243008 e8???????? c644243003 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   8d5c2414             | lea                 ebx, [esp + 0x14]
            //   c644243008           | mov                 byte ptr [esp + 0x30], 8
            //   e8????????           |                     
            //   c644243003           | mov                 byte ptr [esp + 0x30], 3

        $sequence_1 = { 750d 8d460c 55 e8???????? 84c0 7436 8b4c242c }
            // n = 7, score = 100
            //   750d                 | jne                 0xf
            //   8d460c               | lea                 eax, [esi + 0xc]
            //   55                   | push                ebp
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   7436                 | je                  0x38
            //   8b4c242c             | mov                 ecx, dword ptr [esp + 0x2c]

        $sequence_2 = { c644242c07 8b442434 51 83c0f0 89642420 8bf4 e8???????? }
            // n = 7, score = 100
            //   c644242c07           | mov                 byte ptr [esp + 0x2c], 7
            //   8b442434             | mov                 eax, dword ptr [esp + 0x34]
            //   51                   | push                ecx
            //   83c0f0               | add                 eax, -0x10
            //   89642420             | mov                 dword ptr [esp + 0x20], esp
            //   8bf4                 | mov                 esi, esp
            //   e8????????           |                     

        $sequence_3 = { eb12 8b442420 8b4804 51 ff15???????? }
            // n = 5, score = 100
            //   eb12                 | jmp                 0x14
            //   8b442420             | mov                 eax, dword ptr [esp + 0x20]
            //   8b4804               | mov                 ecx, dword ptr [eax + 4]
            //   51                   | push                ecx
            //   ff15????????         |                     

        $sequence_4 = { 8b00 83c404 50 e8???????? 8b9548ffffff 894250 8b8554ffffff }
            // n = 7, score = 100
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   83c404               | add                 esp, 4
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b9548ffffff         | mov                 edx, dword ptr [ebp - 0xb8]
            //   894250               | mov                 dword ptr [edx + 0x50], eax
            //   8b8554ffffff         | mov                 eax, dword ptr [ebp - 0xac]

        $sequence_5 = { 85f6 0f8c09020000 3bf1 0f8f01020000 03c6 }
            // n = 5, score = 100
            //   85f6                 | test                esi, esi
            //   0f8c09020000         | jl                  0x20f
            //   3bf1                 | cmp                 esi, ecx
            //   0f8f01020000         | jg                  0x207
            //   03c6                 | add                 eax, esi

        $sequence_6 = { 8d5c2410 c64424300c e8???????? b303 885c2430 8b44241c }
            // n = 6, score = 100
            //   8d5c2410             | lea                 ebx, [esp + 0x10]
            //   c64424300c           | mov                 byte ptr [esp + 0x30], 0xc
            //   e8????????           |                     
            //   b303                 | mov                 bl, 3
            //   885c2430             | mov                 byte ptr [esp + 0x30], bl
            //   8b44241c             | mov                 eax, dword ptr [esp + 0x1c]

        $sequence_7 = { 50 b9???????? e8???????? 8d4c2420 51 8d4c2450 c68424a80000002d }
            // n = 7, score = 100
            //   50                   | push                eax
            //   b9????????           |                     
            //   e8????????           |                     
            //   8d4c2420             | lea                 ecx, [esp + 0x20]
            //   51                   | push                ecx
            //   8d4c2450             | lea                 ecx, [esp + 0x50]
            //   c68424a80000002d     | mov                 byte ptr [esp + 0xa8], 0x2d

        $sequence_8 = { 8d4c2440 e8???????? 8d542444 68???????? b314 }
            // n = 5, score = 100
            //   8d4c2440             | lea                 ecx, [esp + 0x40]
            //   e8????????           |                     
            //   8d542444             | lea                 edx, [esp + 0x44]
            //   68????????           |                     
            //   b314                 | mov                 bl, 0x14

        $sequence_9 = { 83c404 56 8944241c ff15???????? }
            // n = 4, score = 100
            //   83c404               | add                 esp, 4
            //   56                   | push                esi
            //   8944241c             | mov                 dword ptr [esp + 0x1c], eax
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 344064
}