rule win_makloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.makloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.makloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6bca00 8b440dbc 8b540dc0 b127 }
            // n = 4, score = 200
            //   6bca00               | imul                ecx, edx, 0
            //   8b440dbc             | mov                 eax, dword ptr [ebp + ecx - 0x44]
            //   8b540dc0             | mov                 edx, dword ptr [ebp + ecx - 0x40]
            //   b127                 | mov                 cl, 0x27

        $sequence_1 = { c7857cebffff00000000 c78580ebffff00000000 8d8554e5ffff 898584ebffff c78588ebffff00000000 8d8d74ebffff }
            // n = 6, score = 200
            //   c7857cebffff00000000     | mov    dword ptr [ebp - 0x1484], 0
            //   c78580ebffff00000000     | mov    dword ptr [ebp - 0x1480], 0
            //   8d8554e5ffff         | lea                 eax, [ebp - 0x1aac]
            //   898584ebffff         | mov                 dword ptr [ebp - 0x147c], eax
            //   c78588ebffff00000000     | mov    dword ptr [ebp - 0x1478], 0
            //   8d8d74ebffff         | lea                 ecx, [ebp - 0x148c]

        $sequence_2 = { 33d2 8b45fc 83c003 8810 8b45fc 8be5 }
            // n = 6, score = 200
            //   33d2                 | xor                 edx, edx
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   83c003               | add                 eax, 3
            //   8810                 | mov                 byte ptr [eax], dl
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8be5                 | mov                 esp, ebp

        $sequence_3 = { a1???????? 33c5 8945fc c745c000100000 }
            // n = 4, score = 200
            //   a1????????           |                     
            //   33c5                 | xor                 eax, ebp
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   c745c000100000       | mov                 dword ptr [ebp - 0x40], 0x1000

        $sequence_4 = { 8b94d530fdffff b103 e8???????? 0bd8 8b8520fdffff 0bc2 33f3 }
            // n = 7, score = 200
            //   8b94d530fdffff       | mov                 edx, dword ptr [ebp + edx*8 - 0x2d0]
            //   b103                 | mov                 cl, 3
            //   e8????????           |                     
            //   0bd8                 | or                  ebx, eax
            //   8b8520fdffff         | mov                 eax, dword ptr [ebp - 0x2e0]
            //   0bc2                 | or                  eax, edx
            //   33f3                 | xor                 esi, ebx

        $sequence_5 = { e8???????? 8818 ebbf 6a09 8b4df8 83c101 e8???????? }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8818                 | mov                 byte ptr [eax], bl
            //   ebbf                 | jmp                 0xffffffc1
            //   6a09                 | push                9
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   83c101               | add                 ecx, 1
            //   e8????????           |                     

        $sequence_6 = { 8b540dc0 b122 e8???????? 8bd8 }
            // n = 4, score = 200
            //   8b540dc0             | mov                 edx, dword ptr [ebp + ecx - 0x40]
            //   b122                 | mov                 cl, 0x22
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax

        $sequence_7 = { 89856ce6ffff 33d2 899514e5ffff 899518e5ffff }
            // n = 4, score = 200
            //   89856ce6ffff         | mov                 dword ptr [ebp - 0x1994], eax
            //   33d2                 | xor                 edx, edx
            //   899514e5ffff         | mov                 dword ptr [ebp - 0x1aec], edx
            //   899518e5ffff         | mov                 dword ptr [ebp - 0x1ae8], edx

        $sequence_8 = { 8b08 8b55cc 52 8b410c }
            // n = 4, score = 200
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   8b55cc               | mov                 edx, dword ptr [ebp - 0x34]
            //   52                   | push                edx
            //   8b410c               | mov                 eax, dword ptr [ecx + 0xc]

        $sequence_9 = { 884130 ba01000000 6bc230 8b4d08 0fb61401 52 8b4dfc }
            // n = 7, score = 200
            //   884130               | mov                 byte ptr [ecx + 0x30], al
            //   ba01000000           | mov                 edx, 1
            //   6bc230               | imul                eax, edx, 0x30
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   0fb61401             | movzx               edx, byte ptr [ecx + eax]
            //   52                   | push                edx
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]

    condition:
        7 of them and filesize < 335872
}