rule win_makop_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.makop."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.makop"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 5e 5b 83c41c c3 ffd7 50 e8???????? }
            // n = 7, score = 100
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   83c41c               | add                 esp, 0x1c
            //   c3                   | ret                 
            //   ffd7                 | call                edi
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_1 = { 8bc6 e8???????? 894630 8b4500 8903 8b0f }
            // n = 6, score = 100
            //   8bc6                 | mov                 eax, esi
            //   e8????????           |                     
            //   894630               | mov                 dword ptr [esi + 0x30], eax
            //   8b4500               | mov                 eax, dword ptr [ebp]
            //   8903                 | mov                 dword ptr [ebx], eax
            //   8b0f                 | mov                 ecx, dword ptr [edi]

        $sequence_2 = { 894118 8b0e c6412800 e8???????? }
            // n = 4, score = 100
            //   894118               | mov                 dword ptr [ecx + 0x18], eax
            //   8b0e                 | mov                 ecx, dword ptr [esi]
            //   c6412800             | mov                 byte ptr [ecx + 0x28], 0
            //   e8????????           |                     

        $sequence_3 = { ff15???????? 8bf0 83feff 744f 8bc7 8a08 83c001 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   83feff               | cmp                 esi, -1
            //   744f                 | je                  0x51
            //   8bc7                 | mov                 eax, edi
            //   8a08                 | mov                 cl, byte ptr [eax]
            //   83c001               | add                 eax, 1

        $sequence_4 = { 8d04b8 7414 8b00 50 6a00 ffd5 50 }
            // n = 7, score = 100
            //   8d04b8               | lea                 eax, [eax + edi*4]
            //   7414                 | je                  0x16
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   50                   | push                eax
            //   6a00                 | push                0
            //   ffd5                 | call                ebp
            //   50                   | push                eax

        $sequence_5 = { 833e00 8b35???????? c744240c00000000 7645 8b5c2410 8da42400000000 8b0b }
            // n = 7, score = 100
            //   833e00               | cmp                 dword ptr [esi], 0
            //   8b35????????         |                     
            //   c744240c00000000     | mov                 dword ptr [esp + 0xc], 0
            //   7645                 | jbe                 0x47
            //   8b5c2410             | mov                 ebx, dword ptr [esp + 0x10]
            //   8da42400000000       | lea                 esp, [esp]
            //   8b0b                 | mov                 ecx, dword ptr [ebx]

        $sequence_6 = { 53 a3???????? ff15???????? 50 ff15???????? 8d742418 e8???????? }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   a3????????           |                     
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8d742418             | lea                 esi, [esp + 0x18]
            //   e8????????           |                     

        $sequence_7 = { 56 e8???????? 8d4e28 51 6a0a 8bc6 e8???????? }
            // n = 7, score = 100
            //   56                   | push                esi
            //   e8????????           |                     
            //   8d4e28               | lea                 ecx, [esi + 0x28]
            //   51                   | push                ecx
            //   6a0a                 | push                0xa
            //   8bc6                 | mov                 eax, esi
            //   e8????????           |                     

        $sequence_8 = { c3 ffd7 50 e8???????? 83c404 5f 5e }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   ffd7                 | call                edi
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_9 = { 6a00 8d4c2414 51 52 57 55 c744242800000000 }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   8d4c2414             | lea                 ecx, [esp + 0x14]
            //   51                   | push                ecx
            //   52                   | push                edx
            //   57                   | push                edi
            //   55                   | push                ebp
            //   c744242800000000     | mov                 dword ptr [esp + 0x28], 0

    condition:
        7 of them and filesize < 107520
}