rule win_maktub_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.maktub."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.maktub"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffd0 f7d8 1bc0 f7d8 8be5 }
            // n = 5, score = 400
            //   ffd0                 | call                eax
            //   f7d8                 | neg                 eax
            //   1bc0                 | sbb                 eax, eax
            //   f7d8                 | neg                 eax
            //   8be5                 | mov                 esp, ebp

        $sequence_1 = { ff15???????? eb0a 57 6a08 }
            // n = 4, score = 300
            //   ff15????????         |                     
            //   eb0a                 | jmp                 0xc
            //   57                   | push                edi
            //   6a08                 | push                8

        $sequence_2 = { ff15???????? eb02 33c0 46 }
            // n = 4, score = 300
            //   ff15????????         |                     
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax
            //   46                   | inc                 esi

        $sequence_3 = { ff15???????? eb02 33db 8b4df4 }
            // n = 4, score = 300
            //   ff15????????         |                     
            //   eb02                 | jmp                 4
            //   33db                 | xor                 ebx, ebx
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]

        $sequence_4 = { ff15???????? e9???????? 8d43f4 3d???????? 0f84c1000000 833d????????00 }
            // n = 6, score = 300
            //   ff15????????         |                     
            //   e9????????           |                     
            //   8d43f4               | lea                 eax, [ebx - 0xc]
            //   3d????????           |                     
            //   0f84c1000000         | je                  0xc7
            //   833d????????00       |                     

        $sequence_5 = { e8???????? 8b75fc 8b4df0 83c305 8a4513 }
            // n = 5, score = 300
            //   e8????????           |                     
            //   8b75fc               | mov                 esi, dword ptr [ebp - 4]
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   83c305               | add                 ebx, 5
            //   8a4513               | mov                 al, byte ptr [ebp + 0x13]

        $sequence_6 = { ff15???????? f6c301 0f8414010000 8d46fc }
            // n = 4, score = 300
            //   ff15????????         |                     
            //   f6c301               | test                bl, 1
            //   0f8414010000         | je                  0x11a
            //   8d46fc               | lea                 eax, [esi - 4]

        $sequence_7 = { ff30 e8???????? 8bc7 5f 5e 5b }
            // n = 6, score = 200
            //   ff30                 | push                dword ptr [eax]
            //   e8????????           |                     
            //   8bc7                 | mov                 eax, edi
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

        $sequence_8 = { 8bf8 c785d4fdffff2c020000 8d85d4fdffff 50 57 68???????? }
            // n = 6, score = 100
            //   8bf8                 | mov                 edi, eax
            //   c785d4fdffff2c020000     | mov    dword ptr [ebp - 0x22c], 0x22c
            //   8d85d4fdffff         | lea                 eax, [ebp - 0x22c]
            //   50                   | push                eax
            //   57                   | push                edi
            //   68????????           |                     

        $sequence_9 = { 8d4f14 8b18 8b7004 8d45e8 }
            // n = 4, score = 100
            //   8d4f14               | lea                 ecx, [edi + 0x14]
            //   8b18                 | mov                 ebx, dword ptr [eax]
            //   8b7004               | mov                 esi, dword ptr [eax + 4]
            //   8d45e8               | lea                 eax, [ebp - 0x18]

        $sequence_10 = { 8bf8 8d442428 6a50 50 897c2424 }
            // n = 5, score = 100
            //   8bf8                 | mov                 edi, eax
            //   8d442428             | lea                 eax, [esp + 0x28]
            //   6a50                 | push                0x50
            //   50                   | push                eax
            //   897c2424             | mov                 dword ptr [esp + 0x24], edi

        $sequence_11 = { 8d4f2c e8???????? 84c0 7578 }
            // n = 4, score = 100
            //   8d4f2c               | lea                 ecx, [edi + 0x2c]
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   7578                 | jne                 0x7a

        $sequence_12 = { 8bf8 c744242000000000 f7642424 8bcf 0fafcd 8bd8 8b44241c }
            // n = 7, score = 100
            //   8bf8                 | mov                 edi, eax
            //   c744242000000000     | mov                 dword ptr [esp + 0x20], 0
            //   f7642424             | mul                 dword ptr [esp + 0x24]
            //   8bcf                 | mov                 ecx, edi
            //   0fafcd               | imul                ecx, ebp
            //   8bd8                 | mov                 ebx, eax
            //   8b44241c             | mov                 eax, dword ptr [esp + 0x1c]

        $sequence_13 = { 8bf8 8b4c242c 03f2 03710c }
            // n = 4, score = 100
            //   8bf8                 | mov                 edi, eax
            //   8b4c242c             | mov                 ecx, dword ptr [esp + 0x2c]
            //   03f2                 | add                 esi, edx
            //   03710c               | add                 esi, dword ptr [ecx + 0xc]

        $sequence_14 = { 8d4f20 e8???????? 84c0 750f }
            // n = 4, score = 100
            //   8d4f20               | lea                 ecx, [edi + 0x20]
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   750f                 | jne                 0x11

        $sequence_15 = { 8d4f10 e8???????? 8d4f30 8b30 8b5004 8d45f0 }
            // n = 6, score = 100
            //   8d4f10               | lea                 ecx, [edi + 0x10]
            //   e8????????           |                     
            //   8d4f30               | lea                 ecx, [edi + 0x30]
            //   8b30                 | mov                 esi, dword ptr [eax]
            //   8b5004               | mov                 edx, dword ptr [eax + 4]
            //   8d45f0               | lea                 eax, [ebp - 0x10]

        $sequence_16 = { 8d4f34 e8???????? 8d4f14 8b18 }
            // n = 4, score = 100
            //   8d4f34               | lea                 ecx, [edi + 0x34]
            //   e8????????           |                     
            //   8d4f14               | lea                 ecx, [edi + 0x14]
            //   8b18                 | mov                 ebx, dword ptr [eax]

        $sequence_17 = { 8bf8 8db508040000 b917000000 53 }
            // n = 4, score = 100
            //   8bf8                 | mov                 edi, eax
            //   8db508040000         | lea                 esi, [ebp + 0x408]
            //   b917000000           | mov                 ecx, 0x17
            //   53                   | push                ebx

        $sequence_18 = { 8d4f28 89471c 33c0 c6472000 }
            // n = 4, score = 100
            //   8d4f28               | lea                 ecx, [edi + 0x28]
            //   89471c               | mov                 dword ptr [edi + 0x1c], eax
            //   33c0                 | xor                 eax, eax
            //   c6472000             | mov                 byte ptr [edi + 0x20], 0

        $sequence_19 = { 8bf8 897dec 33db 66895f0c 895dfc 8b450c }
            // n = 6, score = 100
            //   8bf8                 | mov                 edi, eax
            //   897dec               | mov                 dword ptr [ebp - 0x14], edi
            //   33db                 | xor                 ebx, ebx
            //   66895f0c             | mov                 word ptr [edi + 0xc], bx
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]

        $sequence_20 = { 8d4f30 e8???????? 8b470c 8d4d10 }
            // n = 4, score = 100
            //   8d4f30               | lea                 ecx, [edi + 0x30]
            //   e8????????           |                     
            //   8b470c               | mov                 eax, dword ptr [edi + 0xc]
            //   8d4d10               | lea                 ecx, [ebp + 0x10]

    condition:
        7 of them and filesize < 3063808
}