rule win_malumpos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.malumpos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.malumpos"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b450c 3b38 731e 8bd9 }
            // n = 4, score = 100
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   3b38                 | cmp                 edi, dword ptr [eax]
            //   731e                 | jae                 0x20
            //   8bd9                 | mov                 ebx, ecx

        $sequence_1 = { 59 56 8bf3 5e 56 }
            // n = 5, score = 100
            //   59                   | pop                 ecx
            //   56                   | push                esi
            //   8bf3                 | mov                 esi, ebx
            //   5e                   | pop                 esi
            //   56                   | push                esi

        $sequence_2 = { 8db408f8000000 8b4608 894568 3bc3 0f84d9000000 }
            // n = 5, score = 100
            //   8db408f8000000       | lea                 esi, [eax + ecx + 0xf8]
            //   8b4608               | mov                 eax, dword ptr [esi + 8]
            //   894568               | mov                 dword ptr [ebp + 0x68], eax
            //   3bc3                 | cmp                 eax, ebx
            //   0f84d9000000         | je                  0xdf

        $sequence_3 = { 5a 66a9a02f fc f5 a1???????? 8b4015 6a04 }
            // n = 7, score = 100
            //   5a                   | pop                 edx
            //   66a9a02f             | test                ax, 0x2fa0
            //   fc                   | cld                 
            //   f5                   | cmc                 
            //   a1????????           |                     
            //   8b4015               | mov                 eax, dword ptr [eax + 0x15]
            //   6a04                 | push                4

        $sequence_4 = { 5e 6685db 55 80c400 5d 56 }
            // n = 6, score = 100
            //   5e                   | pop                 esi
            //   6685db               | test                bx, bx
            //   55                   | push                ebp
            //   80c400               | add                 ah, 0
            //   5d                   | pop                 ebp
            //   56                   | push                esi

        $sequence_5 = { 59 7405 0d00000000 80ec00 }
            // n = 4, score = 100
            //   59                   | pop                 ecx
            //   7405                 | je                  7
            //   0d00000000           | or                  eax, 0
            //   80ec00               | sub                 ah, 0

        $sequence_6 = { e8???????? 68???????? a3???????? ffd0 810d????????00200000 be???????? }
            // n = 6, score = 100
            //   e8????????           |                     
            //   68????????           |                     
            //   a3????????           |                     
            //   ffd0                 | call                eax
            //   810d????????00200000     |     
            //   be????????           |                     

        $sequence_7 = { 50 ff35???????? ff15???????? 817d6003010000 }
            // n = 4, score = 100
            //   50                   | push                eax
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   817d6003010000       | cmp                 dword ptr [ebp + 0x60], 0x103

        $sequence_8 = { 85c0 7446 8b400c 56 8b700c 68???????? 57 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   7446                 | je                  0x48
            //   8b400c               | mov                 eax, dword ptr [eax + 0xc]
            //   56                   | push                esi
            //   8b700c               | mov                 esi, dword ptr [eax + 0xc]
            //   68????????           |                     
            //   57                   | push                edi

        $sequence_9 = { 8d4520 50 ff15???????? 8d4520 }
            // n = 4, score = 100
            //   8d4520               | lea                 eax, [ebp + 0x20]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8d4520               | lea                 eax, [ebp + 0x20]

    condition:
        7 of them and filesize < 542720
}