rule win_mangzamel_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mangzamel."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mangzamel"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bce e8???????? 8b45dc 33ff 85c0 }
            // n = 5, score = 400
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   8b45dc               | mov                 eax, dword ptr [ebp - 0x24]
            //   33ff                 | xor                 edi, edi
            //   85c0                 | test                eax, eax

        $sequence_1 = { e8???????? 8d8564ffffff c745e40d011133 50 e8???????? 83c428 40 }
            // n = 7, score = 400
            //   e8????????           |                     
            //   8d8564ffffff         | lea                 eax, [ebp - 0x9c]
            //   c745e40d011133       | mov                 dword ptr [ebp - 0x1c], 0x3311010d
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c428               | add                 esp, 0x28
            //   40                   | inc                 eax

        $sequence_2 = { 57 8d4dec c645fc02 e8???????? 85c0 0f8e95000000 57 }
            // n = 7, score = 400
            //   57                   | push                edi
            //   8d4dec               | lea                 ecx, [ebp - 0x14]
            //   c645fc02             | mov                 byte ptr [ebp - 4], 2
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f8e95000000         | jle                 0x9b
            //   57                   | push                edi

        $sequence_3 = { 7412 ff7508 8d4e08 50 e8???????? 8b450c 894624 }
            // n = 7, score = 400
            //   7412                 | je                  0x14
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8d4e08               | lea                 ecx, [esi + 8]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   894624               | mov                 dword ptr [esi + 0x24], eax

        $sequence_4 = { 6aff 57 68???????? 8d4de4 e8???????? 8bce e8???????? }
            // n = 7, score = 400
            //   6aff                 | push                -1
            //   57                   | push                edi
            //   68????????           |                     
            //   8d4de4               | lea                 ecx, [ebp - 0x1c]
            //   e8????????           |                     
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     

        $sequence_5 = { e8???????? 8d45ec 68???????? 50 e8???????? 83c41c 8d45ec }
            // n = 7, score = 400
            //   e8????????           |                     
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c41c               | add                 esp, 0x1c
            //   8d45ec               | lea                 eax, [ebp - 0x14]

        $sequence_6 = { e8???????? 57 e8???????? 59 55 8d4b20 }
            // n = 6, score = 400
            //   e8????????           |                     
            //   57                   | push                edi
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   55                   | push                ebp
            //   8d4b20               | lea                 ecx, [ebx + 0x20]

        $sequence_7 = { 8bc8 c1e910 c1e818 880a 33ff 897514 8b4d14 }
            // n = 7, score = 400
            //   8bc8                 | mov                 ecx, eax
            //   c1e910               | shr                 ecx, 0x10
            //   c1e818               | shr                 eax, 0x18
            //   880a                 | mov                 byte ptr [edx], cl
            //   33ff                 | xor                 edi, edi
            //   897514               | mov                 dword ptr [ebp + 0x14], esi
            //   8b4d14               | mov                 ecx, dword ptr [ebp + 0x14]

        $sequence_8 = { 8b06 8365fc00 8bce b301 ff5010 3d04000102 }
            // n = 6, score = 400
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   8bce                 | mov                 ecx, esi
            //   b301                 | mov                 bl, 1
            //   ff5010               | call                dword ptr [eax + 0x10]
            //   3d04000102           | cmp                 eax, 0x2010004

        $sequence_9 = { eb34 68???????? 57 ffd6 59 85c0 59 }
            // n = 7, score = 400
            //   eb34                 | jmp                 0x36
            //   68????????           |                     
            //   57                   | push                edi
            //   ffd6                 | call                esi
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   59                   | pop                 ecx

    condition:
        7 of them and filesize < 360448
}