rule win_manjusaka_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.manjusaka."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.manjusaka"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488b4110 4885c0 0f8482000000 488b31 486bf870 31db 48837c1e0800 }
            // n = 7, score = 100
            //   488b4110             | mov                 ebp, dword ptr [edi]
            //   4885c0               | mov                 dword ptr [esp + 0x44], ebx
            //   0f8482000000         | dec                 eax
            //   488b31               | mov                 dword ptr [esp + 0x20], edi
            //   486bf870             | dec                 eax
            //   31db                 | mov                 dword ptr [esp + 0x28], eax
            //   48837c1e0800         | dec                 eax

        $sequence_1 = { 8be9 2bef 4803fa 399c2490000000 7417 498b4d70 e8???????? }
            // n = 7, score = 100
            //   8be9                 | mov                 esi, ebp
            //   2bef                 | dec                 eax
            //   4803fa               | mov                 edx, dword ptr [eax + edx*8]
            //   399c2490000000       | test                eax, eax
            //   7417                 | dec                 eax
            //   498b4d70             | lea                 eax, [0xde200]
            //   e8????????           |                     

        $sequence_2 = { f048ff08 750d 488d8c2438010000 e8???????? 80bc24c801000002 740d 488d8c2440010000 }
            // n = 7, score = 100
            //   f048ff08             | mov                 edx, 1
            //   750d                 | jmp                 0x8d3
            //   488d8c2438010000     | dec                 esp
            //   e8????????           |                     
            //   80bc24c801000002     | lea                 eax, [0x13cd77]
            //   740d                 | jmp                 0x8cd
            //   488d8c2440010000     | jmp                 0x8f1

        $sequence_3 = { 85c0 750e b9667b0200 e8???????? 8bc8 ebe2 488b4b18 }
            // n = 7, score = 100
            //   85c0                 | dec                 eax
            //   750e                 | mov                 ebp, dword ptr [esp + 0x30]
            //   b9667b0200           | dec                 ecx
            //   e8????????           |                     
            //   8bc8                 | add                 ebp, 8
            //   ebe2                 | test                eax, eax
            //   488b4b18             | je                  0xb6c

        $sequence_4 = { ba08000000 e8???????? 0f0b 488d4134 c3 488d4135 c3 }
            // n = 7, score = 100
            //   ba08000000           | jmp                 0xde6
            //   e8????????           |                     
            //   0f0b                 | dec                 esp
            //   488d4134             | mov                 dword ptr [ebp + 0x1130], edi
            //   c3                   | dec                 eax
            //   488d4135             | lea                 ecx, [0x10e6bb]
            //   c3                   | dec                 esp

        $sequence_5 = { 81fa00fc0000 7323 66c741100100 6644894112 48c1e010 4883c801 c3 }
            // n = 7, score = 100
            //   81fa00fc0000         | cmp                 dword ptr [ebx + 0x28], edi
            //   7323                 | jle                 0x64e
            //   66c741100100         | cmp                 byte ptr [edx + 1], 0x3a
            //   6644894112           | jne                 0x8c1
            //   48c1e010             | mov                 al, byte ptr [edx]
            //   4883c801             | mov                 edx, eax
            //   c3                   | and                 dl, 0xdf

        $sequence_6 = { e8???????? 4885d2 7415 4c39e8 7509 4c39e2 0f846a010000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4885d2               | mov                 ecx, eax
            //   7415                 | dec                 ecx
            //   4c39e8               | mov                 edi, edx
            //   7509                 | dec                 eax
            //   4c39e2               | lea                 edi, [ecx + 0xd8]
            //   0f846a010000         | dec                 eax

        $sequence_7 = { 8a8c0ca2000000 41300c2f 488d4d01 4889cd 4939cc 75b8 488b442440 }
            // n = 7, score = 100
            //   8a8c0ca2000000       | mov                 esi, dword ptr [ebp - 0x59]
            //   41300c2f             | dec                 esp
            //   488d4d01             | mov                 eax, dword ptr [esp + 0x48]
            //   4889cd               | inc                 ecx
            //   4939cc               | mov                 ebx, 1
            //   75b8                 | mov                 cl, byte ptr [edi + 0x5e]
            //   488b442440           | mov                 byte ptr [eax + 4], cl

        $sequence_8 = { f048ff00 0f8e64050000 4889c7 b930000000 ba08000000 e8???????? 4885c0 }
            // n = 7, score = 100
            //   f048ff00             | movups              xmm0, xmmword ptr [edx]
            //   0f8e64050000         | movups              xmm1, xmmword ptr [edx + 0x10]
            //   4889c7               | movups              xmm2, xmmword ptr [edx + 0x20]
            //   b930000000           | jmp                 0x468
            //   ba08000000           | dec                 eax
            //   e8????????           |                     
            //   4885c0               | mov                 dword ptr [esp + 8], ebx

        $sequence_9 = { 8806 4883c440 5e c3 4889d1 4c89c2 4d89c8 }
            // n = 7, score = 100
            //   8806                 | inc                 esp
            //   4883c440             | lea                 eax, [ecx + 0x30]
            //   5e                   | dec                 eax
            //   c3                   | lea                 ecx, [ebp - 0x29]
            //   4889d1               | xor                 edx, edx
            //   4c89c2               | test                ebx, ebx
            //   4d89c8               | je                  0x10e3

    condition:
        7 of them and filesize < 4772864
}