rule win_maoloa_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.maoloa."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.maoloa"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d4c241c e8???????? 8bf0 83c404 85f6 7524 0f10842468010000 }
            // n = 7, score = 100
            //   8d4c241c             | lea                 ecx, [esp + 0x1c]
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   83c404               | add                 esp, 4
            //   85f6                 | test                esi, esi
            //   7524                 | jne                 0x26
            //   0f10842468010000     | movups              xmm0, xmmword ptr [esp + 0x168]

        $sequence_1 = { 90 ff0f 8d4dd8 33d2 e8???????? 8bf0 85f6 }
            // n = 7, score = 100
            //   90                   | nop                 
            //   ff0f                 | dec                 dword ptr [edi]
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   33d2                 | xor                 edx, edx
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi

        $sequence_2 = { 53 ff15???????? 85c0 7595 53 }
            // n = 5, score = 100
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7595                 | jne                 0xffffff97
            //   53                   | push                ebx

        $sequence_3 = { 8b4d0c 81ff00040000 7615 5f b8fcffffff 5b 8b4dfc }
            // n = 7, score = 100
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   81ff00040000         | cmp                 edi, 0x400
            //   7615                 | jbe                 0x17
            //   5f                   | pop                 edi
            //   b8fcffffff           | mov                 eax, 0xfffffffc
            //   5b                   | pop                 ebx
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]

        $sequence_4 = { 897018 8bcb 895d08 c1e918 89581c 0fb69998f14200 8b4d08 }
            // n = 7, score = 100
            //   897018               | mov                 dword ptr [eax + 0x18], esi
            //   8bcb                 | mov                 ecx, ebx
            //   895d08               | mov                 dword ptr [ebp + 8], ebx
            //   c1e918               | shr                 ecx, 0x18
            //   89581c               | mov                 dword ptr [eax + 0x1c], ebx
            //   0fb69998f14200       | movzx               ebx, byte ptr [ecx + 0x42f198]
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]

        $sequence_5 = { 8b45f4 8d1c9f 338310100000 81c710100000 314df0 8945f4 8b45ac }
            // n = 7, score = 100
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   8d1c9f               | lea                 ebx, [edi + ebx*4]
            //   338310100000         | xor                 eax, dword ptr [ebx + 0x1010]
            //   81c710100000         | add                 edi, 0x1010
            //   314df0               | xor                 dword ptr [ebp - 0x10], ecx
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   8b45ac               | mov                 eax, dword ptr [ebp - 0x54]

        $sequence_6 = { 8d4dd8 33d2 e8???????? 8bf0 85f6 0f85dc010000 837dbc01 }
            // n = 7, score = 100
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   33d2                 | xor                 edx, edx
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   0f85dc010000         | jne                 0x1e2
            //   837dbc01             | cmp                 dword ptr [ebp - 0x44], 1

        $sequence_7 = { c3 8b4d9c 53 52 33d2 e8???????? }
            // n = 6, score = 100
            //   c3                   | ret                 
            //   8b4d9c               | mov                 ecx, dword ptr [ebp - 0x64]
            //   53                   | push                ebx
            //   52                   | push                edx
            //   33d2                 | xor                 edx, edx
            //   e8????????           |                     

        $sequence_8 = { 8bc6 c1e002 50 8b85b4f8ffff 0fb70485cc444200 8d0485c83b4200 }
            // n = 6, score = 100
            //   8bc6                 | mov                 eax, esi
            //   c1e002               | shl                 eax, 2
            //   50                   | push                eax
            //   8b85b4f8ffff         | mov                 eax, dword ptr [ebp - 0x74c]
            //   0fb70485cc444200     | movzx               eax, word ptr [eax*4 + 0x4244cc]
            //   8d0485c83b4200       | lea                 eax, [eax*4 + 0x423bc8]

        $sequence_9 = { 8bf0 6a08 6a08 89742430 e8???????? 83c410 }
            // n = 6, score = 100
            //   8bf0                 | mov                 esi, eax
            //   6a08                 | push                8
            //   6a08                 | push                8
            //   89742430             | mov                 dword ptr [esp + 0x30], esi
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10

    condition:
        7 of them and filesize < 586752
}