rule win_mapiget_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mapiget."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mapiget"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 59 7433 8305????????20 8d0cbd20174100 8d9000010000 }
            // n = 5, score = 100
            //   59                   | pop                 ecx
            //   7433                 | je                  0x35
            //   8305????????20       |                     
            //   8d0cbd20174100       | lea                 ecx, [edi*4 + 0x411720]
            //   8d9000010000         | lea                 edx, [eax + 0x100]

        $sequence_1 = { 50 51 52 c744244044000000 c744244808e24000 c744246c01000000 ff15???????? }
            // n = 7, score = 100
            //   50                   | push                eax
            //   51                   | push                ecx
            //   52                   | push                edx
            //   c744244044000000     | mov                 dword ptr [esp + 0x40], 0x44
            //   c744244808e24000     | mov                 dword ptr [esp + 0x48], 0x40e208
            //   c744246c01000000     | mov                 dword ptr [esp + 0x6c], 1
            //   ff15????????         |                     

        $sequence_2 = { b97f000000 33c0 8d7c242a 66895c2428 66899c2428020000 }
            // n = 5, score = 100
            //   b97f000000           | mov                 ecx, 0x7f
            //   33c0                 | xor                 eax, eax
            //   8d7c242a             | lea                 edi, [esp + 0x2a]
            //   66895c2428           | mov                 word ptr [esp + 0x28], bx
            //   66899c2428020000     | mov                 word ptr [esp + 0x228], bx

        $sequence_3 = { 8d7c2418 8b542468 f3ab 6689442444 8d442404 8d4c2414 50 }
            // n = 7, score = 100
            //   8d7c2418             | lea                 edi, [esp + 0x18]
            //   8b542468             | mov                 edx, dword ptr [esp + 0x68]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   6689442444           | mov                 word ptr [esp + 0x44], ax
            //   8d442404             | lea                 eax, [esp + 4]
            //   8d4c2414             | lea                 ecx, [esp + 0x14]
            //   50                   | push                eax

        $sequence_4 = { 8b4c2468 6a00 6a00 6a00 52 }
            // n = 5, score = 100
            //   8b4c2468             | mov                 ecx, dword ptr [esp + 0x68]
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   52                   | push                edx

        $sequence_5 = { 8d85f0feffff 52 8d8d70ffffff 50 8d95f0fdffff 51 }
            // n = 6, score = 100
            //   8d85f0feffff         | lea                 eax, [ebp - 0x110]
            //   52                   | push                edx
            //   8d8d70ffffff         | lea                 ecx, [ebp - 0x90]
            //   50                   | push                eax
            //   8d95f0fdffff         | lea                 edx, [ebp - 0x210]
            //   51                   | push                ecx

        $sequence_6 = { 6683bc45eefeffff0a 7517 8d95f0feffff 52 }
            // n = 4, score = 100
            //   6683bc45eefeffff0a     | cmp    word ptr [ebp + eax*2 - 0x112], 0xa
            //   7517                 | jne                 0x19
            //   8d95f0feffff         | lea                 edx, [ebp - 0x110]
            //   52                   | push                edx

        $sequence_7 = { c1e603 8d1c8520174100 8b048520174100 03c6 }
            // n = 4, score = 100
            //   c1e603               | shl                 esi, 3
            //   8d1c8520174100       | lea                 ebx, [eax*4 + 0x411720]
            //   8b048520174100       | mov                 eax, dword ptr [eax*4 + 0x411720]
            //   03c6                 | add                 eax, esi

        $sequence_8 = { 8b5c2408 55 83cdff 56 83fb02 57 be01000000 }
            // n = 7, score = 100
            //   8b5c2408             | mov                 ebx, dword ptr [esp + 8]
            //   55                   | push                ebp
            //   83cdff               | or                  ebp, 0xffffffff
            //   56                   | push                esi
            //   83fb02               | cmp                 ebx, 2
            //   57                   | push                edi
            //   be01000000           | mov                 esi, 1

        $sequence_9 = { 50 e8???????? 83c404 6689bc456effffff 8d8df0feffff }
            // n = 5, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   6689bc456effffff     | mov                 word ptr [ebp + eax*2 - 0x92], di
            //   8d8df0feffff         | lea                 ecx, [ebp - 0x110]

    condition:
        7 of them and filesize < 163840
}