rule win_marap_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.marap."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.marap"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 53 57 52 50 51 68???????? }
            // n = 6, score = 100
            //   53                   | push                ebx
            //   57                   | push                edi
            //   52                   | push                edx
            //   50                   | push                eax
            //   51                   | push                ecx
            //   68????????           |                     

        $sequence_1 = { c1f805 8b048580320110 83e61f c1e606 }
            // n = 4, score = 100
            //   c1f805               | sar                 eax, 5
            //   8b048580320110       | mov                 eax, dword ptr [eax*4 + 0x10013280]
            //   83e61f               | and                 esi, 0x1f
            //   c1e606               | shl                 esi, 6

        $sequence_2 = { 8d3c8580320110 8b07 c1e606 f644300401 7436 833c30ff }
            // n = 6, score = 100
            //   8d3c8580320110       | lea                 edi, [eax*4 + 0x10013280]
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   c1e606               | shl                 esi, 6
            //   f644300401           | test                byte ptr [eax + esi + 4], 1
            //   7436                 | je                  0x38
            //   833c30ff             | cmp                 dword ptr [eax + esi], -1

        $sequence_3 = { 6a01 57 68???????? 89bda8fdffff }
            // n = 4, score = 100
            //   6a01                 | push                1
            //   57                   | push                edi
            //   68????????           |                     
            //   89bda8fdffff         | mov                 dword ptr [ebp - 0x258], edi

        $sequence_4 = { 68???????? 8d9662030000 e8???????? 8b3d???????? 83c410 68???????? 68???????? }
            // n = 7, score = 100
            //   68????????           |                     
            //   8d9662030000         | lea                 edx, [esi + 0x362]
            //   e8????????           |                     
            //   8b3d????????         |                     
            //   83c410               | add                 esp, 0x10
            //   68????????           |                     
            //   68????????           |                     

        $sequence_5 = { eb22 8386e41d00000f eb19 8386e41d000010 }
            // n = 4, score = 100
            //   eb22                 | jmp                 0x24
            //   8386e41d00000f       | add                 dword ptr [esi + 0x1de4], 0xf
            //   eb19                 | jmp                 0x1b
            //   8386e41d000010       | add                 dword ptr [esi + 0x1de4], 0x10

        $sequence_6 = { 0f848d000000 8bc6 8d5002 668b08 83c002 663bcf 75f5 }
            // n = 7, score = 100
            //   0f848d000000         | je                  0x93
            //   8bc6                 | mov                 eax, esi
            //   8d5002               | lea                 edx, [eax + 2]
            //   668b08               | mov                 cx, word ptr [eax]
            //   83c002               | add                 eax, 2
            //   663bcf               | cmp                 cx, di
            //   75f5                 | jne                 0xfffffff7

        $sequence_7 = { 895df8 0f8576ffffff 8bd7 5f 8bc6 5e }
            // n = 6, score = 100
            //   895df8               | mov                 dword ptr [ebp - 8], ebx
            //   0f8576ffffff         | jne                 0xffffff7c
            //   8bd7                 | mov                 edx, edi
            //   5f                   | pop                 edi
            //   8bc6                 | mov                 eax, esi
            //   5e                   | pop                 esi

        $sequence_8 = { 50 8dbeb2010000 57 e8???????? }
            // n = 4, score = 100
            //   50                   | push                eax
            //   8dbeb2010000         | lea                 edi, [esi + 0x1b2]
            //   57                   | push                edi
            //   e8????????           |                     

        $sequence_9 = { 6683f858 770f 0fb7c2 0fbe80d8cb0010 83e00f }
            // n = 5, score = 100
            //   6683f858             | cmp                 ax, 0x58
            //   770f                 | ja                  0x11
            //   0fb7c2               | movzx               eax, dx
            //   0fbe80d8cb0010       | movsx               eax, byte ptr [eax + 0x1000cbd8]
            //   83e00f               | and                 eax, 0xf

    condition:
        7 of them and filesize < 188416
}