rule win_mars_stealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mars_stealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mars_stealer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c404 8945fc 837dfc00 744c 6a00 }
            // n = 5, score = 100
            //   83c404               | add                 esp, 4
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   837dfc00             | cmp                 dword ptr [ebp - 4], 0
            //   744c                 | je                  0x4e
            //   6a00                 | push                0

        $sequence_1 = { e8???????? 83c404 85c0 7443 833d????????00 751e }
            // n = 6, score = 100
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax
            //   7443                 | je                  0x45
            //   833d????????00       |                     
            //   751e                 | jne                 0x20

        $sequence_2 = { 0f90c1 f7d9 0bc8 51 ff15???????? 83c404 8945f4 }
            // n = 7, score = 100
            //   0f90c1               | seto                cl
            //   f7d9                 | neg                 ecx
            //   0bc8                 | or                  ecx, eax
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   83c404               | add                 esp, 4
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax

        $sequence_3 = { 8985fcfdffff c745fcc0270900 6a04 8d45fc 50 6a02 }
            // n = 6, score = 100
            //   8985fcfdffff         | mov                 dword ptr [ebp - 0x204], eax
            //   c745fcc0270900       | mov                 dword ptr [ebp - 4], 0x927c0
            //   6a04                 | push                4
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   6a02                 | push                2

        $sequence_4 = { 51 e8???????? c78548fcffff94000000 8d9548fcffff }
            // n = 4, score = 100
            //   51                   | push                ecx
            //   e8????????           |                     
            //   c78548fcffff94000000     | mov    dword ptr [ebp - 0x3b8], 0x94
            //   8d9548fcffff         | lea                 edx, [ebp - 0x3b8]

        $sequence_5 = { 8bec 81ecc8040000 56 57 c78548fcffff00000000 6890000000 6a00 }
            // n = 7, score = 100
            //   8bec                 | mov                 ebp, esp
            //   81ecc8040000         | sub                 esp, 0x4c8
            //   56                   | push                esi
            //   57                   | push                edi
            //   c78548fcffff00000000     | mov    dword ptr [ebp - 0x3b8], 0
            //   6890000000           | push                0x90
            //   6a00                 | push                0

        $sequence_6 = { 8d85e8d7ffff 50 e8???????? 6888130000 8d8d78ecffff }
            // n = 5, score = 100
            //   8d85e8d7ffff         | lea                 eax, [ebp - 0x2818]
            //   50                   | push                eax
            //   e8????????           |                     
            //   6888130000           | push                0x1388
            //   8d8d78ecffff         | lea                 ecx, [ebp - 0x1388]

        $sequence_7 = { 8b55f0 52 ff15???????? 83c404 8b45e8 }
            // n = 5, score = 100
            //   8b55f0               | mov                 edx, dword ptr [ebp - 0x10]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   83c404               | add                 esp, 4
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]

        $sequence_8 = { 8d8d78ecffff 51 e8???????? 8d95e4d7ffff 52 8d85e0d7ffff 50 }
            // n = 7, score = 100
            //   8d8d78ecffff         | lea                 ecx, [ebp - 0x1388]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8d95e4d7ffff         | lea                 edx, [ebp - 0x281c]
            //   52                   | push                edx
            //   8d85e0d7ffff         | lea                 eax, [ebp - 0x2820]
            //   50                   | push                eax

        $sequence_9 = { 50 ff15???????? 83c404 8985dcf7ffff 8b85dcf7ffff }
            // n = 5, score = 100
            //   50                   | push                eax
            //   ff15????????         |                     
            //   83c404               | add                 esp, 4
            //   8985dcf7ffff         | mov                 dword ptr [ebp - 0x824], eax
            //   8b85dcf7ffff         | mov                 eax, dword ptr [ebp - 0x824]

    condition:
        7 of them and filesize < 219136
}