rule win_matanbuchus_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.matanbuchus."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.matanbuchus"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8955ec 0fb745fc 8b4dd8 668b1441 668955f8 eb0f }
            // n = 6, score = 500
            //   8955ec               | mov                 dword ptr [ebp - 0x14], edx
            //   0fb745fc             | movzx               eax, word ptr [ebp - 4]
            //   8b4dd8               | mov                 ecx, dword ptr [ebp - 0x28]
            //   668b1441             | mov                 dx, word ptr [ecx + eax*2]
            //   668955f8             | mov                 word ptr [ebp - 8], dx
            //   eb0f                 | jmp                 0x11

        $sequence_1 = { 035120 8955dc 8b45f4 8b4d08 03481c 894dcc c745f000000000 }
            // n = 7, score = 500
            //   035120               | add                 edx, dword ptr [ecx + 0x20]
            //   8955dc               | mov                 dword ptr [ebp - 0x24], edx
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   03481c               | add                 ecx, dword ptr [eax + 0x1c]
            //   894dcc               | mov                 dword ptr [ebp - 0x34], ecx
            //   c745f000000000       | mov                 dword ptr [ebp - 0x10], 0

        $sequence_2 = { 51 b801000000 6bc800 8b5508 0fbe040a 85c0 }
            // n = 6, score = 500
            //   51                   | push                ecx
            //   b801000000           | mov                 eax, 1
            //   6bc800               | imul                ecx, eax, 0
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   0fbe040a             | movsx               eax, byte ptr [edx + ecx]
            //   85c0                 | test                eax, eax

        $sequence_3 = { 8b55d4 8b048a 034508 8945d0 0fb74df4 0fb755f8 }
            // n = 6, score = 500
            //   8b55d4               | mov                 edx, dword ptr [ebp - 0x2c]
            //   8b048a               | mov                 eax, dword ptr [edx + ecx*4]
            //   034508               | add                 eax, dword ptr [ebp + 8]
            //   8945d0               | mov                 dword ptr [ebp - 0x30], eax
            //   0fb74df4             | movzx               ecx, word ptr [ebp - 0xc]
            //   0fb755f8             | movzx               edx, word ptr [ebp - 8]

        $sequence_4 = { 41 66894df8 0fb755fc 85d2 }
            // n = 4, score = 500
            //   41                   | inc                 ecx
            //   66894df8             | mov                 word ptr [ebp - 8], cx
            //   0fb755fc             | movzx               edx, word ptr [ebp - 4]
            //   85d2                 | test                edx, edx

        $sequence_5 = { 0fbe1401 33550c 69c293010001 50 b901000000 c1e100 034d08 }
            // n = 7, score = 500
            //   0fbe1401             | movsx               edx, byte ptr [ecx + eax]
            //   33550c               | xor                 edx, dword ptr [ebp + 0xc]
            //   69c293010001         | imul                eax, edx, 0x1000193
            //   50                   | push                eax
            //   b901000000           | mov                 ecx, 1
            //   c1e100               | shl                 ecx, 0
            //   034d08               | add                 ecx, dword ptr [ebp + 8]

        $sequence_6 = { eb04 33c0 eb18 eb82 8b4df4 8b55f4 }
            // n = 6, score = 500
            //   eb04                 | jmp                 6
            //   33c0                 | xor                 eax, eax
            //   eb18                 | jmp                 0x1a
            //   eb82                 | jmp                 0xffffff84
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]

        $sequence_7 = { 81fa4d5a0000 7407 33c0 e9???????? 8b45e8 8b4d08 }
            // n = 6, score = 500
            //   81fa4d5a0000         | cmp                 edx, 0x5a4d
            //   7407                 | je                  9
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]

        $sequence_8 = { ff55f0 6800800000 6a00 8b5508 }
            // n = 4, score = 500
            //   ff55f0               | call                dword ptr [ebp - 0x10]
            //   6800800000           | push                0x8000
            //   6a00                 | push                0
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]

        $sequence_9 = { 8b55f0 8b4214 8945e8 33c9 66894dfc }
            // n = 5, score = 500
            //   8b55f0               | mov                 edx, dword ptr [ebp - 0x10]
            //   8b4214               | mov                 eax, dword ptr [edx + 0x14]
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   33c9                 | xor                 ecx, ecx
            //   66894dfc             | mov                 word ptr [ebp - 4], cx

    condition:
        7 of them and filesize < 13077504
}