rule win_matryoshka_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.matryoshka_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.matryoshka_rat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { b037 c3 b073 c3 }
            // n = 4, score = 400
            //   b037                 | mov                 al, 0x37
            //   c3                   | ret                 
            //   b073                 | mov                 al, 0x73
            //   c3                   | ret                 

        $sequence_1 = { c3 b06f c3 b063 c3 }
            // n = 5, score = 400
            //   c3                   | ret                 
            //   b06f                 | mov                 al, 0x6f
            //   c3                   | ret                 
            //   b063                 | mov                 al, 0x63
            //   c3                   | ret                 

        $sequence_2 = { 8b46fc 8947fc 49 75ed }
            // n = 4, score = 200
            //   8b46fc               | mov                 eax, dword ptr [esi - 4]
            //   8947fc               | mov                 dword ptr [edi - 4], eax
            //   49                   | dec                 ecx
            //   75ed                 | jne                 0xffffffef

        $sequence_3 = { 750a 488bcb e8???????? eb0f 488bd3 488d0df7520400 }
            // n = 6, score = 200
            //   750a                 | dec                 eax
            //   488bcb               | add                 ebx, 0xa
            //   e8????????           |                     
            //   eb0f                 | bts                 dword ptr [edi], 0x12
            //   488bd3               | jmp                 0x54
            //   488d0df7520400       | inc                 ecx

        $sequence_4 = { 7509 bb99ffffff 85db 740d 488bcf }
            // n = 5, score = 200
            //   7509                 | jne                 0xb
            //   bb99ffffff           | mov                 ebx, 0xffffff99
            //   85db                 | test                ebx, ebx
            //   740d                 | je                  0xf
            //   488bcf               | dec                 eax

        $sequence_5 = { 8b4648 48 48 7446 48 }
            // n = 5, score = 200
            //   8b4648               | mov                 eax, dword ptr [esi + 0x48]
            //   48                   | dec                 eax
            //   48                   | dec                 eax
            //   7446                 | je                  0x48
            //   48                   | dec                 eax

        $sequence_6 = { 750a 4883c310 0fba2f11 eb27 41b807000000 488d152bb50200 }
            // n = 6, score = 200
            //   750a                 | lea                 edx, [ebp + 0x40]
            //   4883c310             | dec                 eax
            //   0fba2f11             | mov                 ecx, dword ptr [edi]
            //   eb27                 | jne                 0xc
            //   41b807000000         | dec                 eax
            //   488d152bb50200       | add                 ebx, 0xa

        $sequence_7 = { 8b4704 8b3491 890491 8bd6 }
            // n = 4, score = 200
            //   8b4704               | mov                 eax, dword ptr [edi + 4]
            //   8b3491               | mov                 esi, dword ptr [ecx + edx*4]
            //   890491               | mov                 dword ptr [ecx + edx*4], eax
            //   8bd6                 | mov                 edx, esi

        $sequence_8 = { 750a 443b774c 8d4399 0f45d8 450137 }
            // n = 5, score = 200
            //   750a                 | mov                 dword ptr [ecx + 0x24], 0x2000000
            //   443b774c             | jmp                 0x55
            //   8d4399               | dec                 eax
            //   0f45d8               | cmp                 dword ptr [ecx + 0x30], eax
            //   450137               | je                  0x24

        $sequence_9 = { 750a 4883c30a 0fba2f12 eb4a 41b808000000 488d153eb50200 }
            // n = 6, score = 200
            //   750a                 | cmovne              ebx, eax
            //   4883c30a             | inc                 ebp
            //   0fba2f12             | add                 dword ptr [edi], esi
            //   eb4a                 | dec                 eax
            //   41b808000000         | lea                 edx, [ebp + 0x40]
            //   488d153eb50200       | jne                 0xc

        $sequence_10 = { 8b4704 8bf1 33d1 81e6ff030000 }
            // n = 4, score = 200
            //   8b4704               | mov                 eax, dword ptr [edi + 4]
            //   8bf1                 | mov                 esi, ecx
            //   33d1                 | xor                 edx, ecx
            //   81e6ff030000         | and                 esi, 0x3ff

        $sequence_11 = { 8b4660 89471c 8d4670 894724 }
            // n = 4, score = 200
            //   8b4660               | mov                 eax, dword ptr [esi + 0x60]
            //   89471c               | mov                 dword ptr [edi + 0x1c], eax
            //   8d4670               | lea                 eax, [esi + 0x70]
            //   894724               | mov                 dword ptr [edi + 0x24], eax

        $sequence_12 = { 8b4664 034668 8b4e60 03ca }
            // n = 4, score = 200
            //   8b4664               | mov                 eax, dword ptr [esi + 0x64]
            //   034668               | add                 eax, dword ptr [esi + 0x68]
            //   8b4e60               | mov                 ecx, dword ptr [esi + 0x60]
            //   03ca                 | add                 ecx, edx

        $sequence_13 = { 7509 c7412400000002 eb4c 48394130 }
            // n = 4, score = 200
            //   7509                 | je                  0xf
            //   c7412400000002       | dec                 eax
            //   eb4c                 | mov                 ecx, edi
            //   48394130             | jne                 0xb

    condition:
        7 of them and filesize < 843776
}