rule win_maudi_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.maudi."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.maudi"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 61 6886180000 59 80740fff36 e2f9 }
            // n = 5, score = 400
            //   61                   | popal               
            //   6886180000           | push                0x1886
            //   59                   | pop                 ecx
            //   80740fff36           | xor                 byte ptr [edi + ecx - 1], 0x36
            //   e2f9                 | loop                0xfffffffb

        $sequence_1 = { 5d bf???????? 6a40 6800100000 6886180000 6a00 }
            // n = 6, score = 400
            //   5d                   | pop                 ebp
            //   bf????????           |                     
            //   6a40                 | push                0x40
            //   6800100000           | push                0x1000
            //   6886180000           | push                0x1886
            //   6a00                 | push                0

        $sequence_2 = { 89e5 5d 8b80a4000000 83f806 7546 }
            // n = 5, score = 400
            //   89e5                 | mov                 ebp, esp
            //   5d                   | pop                 ebp
            //   8b80a4000000         | mov                 eax, dword ptr [eax + 0xa4]
            //   83f806               | cmp                 eax, 6
            //   7546                 | jne                 0x48

        $sequence_3 = { 52 68???????? 87d1 87ca 51 }
            // n = 5, score = 400
            //   52                   | push                edx
            //   68????????           |                     
            //   87d1                 | xchg                ecx, edx
            //   87ca                 | xchg                edx, ecx
            //   51                   | push                ecx

        $sequence_4 = { 55 89e5 5d 8b80a4000000 83f806 7546 }
            // n = 6, score = 400
            //   55                   | push                ebp
            //   89e5                 | mov                 ebp, esp
            //   5d                   | pop                 ebp
            //   8b80a4000000         | mov                 eax, dword ptr [eax + 0xa4]
            //   83f806               | cmp                 eax, 6
            //   7546                 | jne                 0x48

        $sequence_5 = { 6804010000 56 68???????? 87d1 }
            // n = 4, score = 400
            //   6804010000           | push                0x104
            //   56                   | push                esi
            //   68????????           |                     
            //   87d1                 | xchg                ecx, edx

        $sequence_6 = { 89e5 81ec04010000 56 55 89e5 5d 89e6 }
            // n = 7, score = 400
            //   89e5                 | mov                 ebp, esp
            //   81ec04010000         | sub                 esp, 0x104
            //   56                   | push                esi
            //   55                   | push                ebp
            //   89e5                 | mov                 ebp, esp
            //   5d                   | pop                 ebp
            //   89e6                 | mov                 esi, esp

        $sequence_7 = { ff25???????? 83c418 6a00 57 56 68???????? 87d1 }
            // n = 7, score = 400
            //   ff25????????         |                     
            //   83c418               | add                 esp, 0x18
            //   6a00                 | push                0
            //   57                   | push                edi
            //   56                   | push                esi
            //   68????????           |                     
            //   87d1                 | xchg                ecx, edx

        $sequence_8 = { 59 59 ff25???????? 68???????? 87d1 87ca }
            // n = 6, score = 400
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   ff25????????         |                     
            //   68????????           |                     
            //   87d1                 | xchg                ecx, edx
            //   87ca                 | xchg                edx, ecx

        $sequence_9 = { 59 e9???????? 55 89e5 5d bf???????? 6a40 }
            // n = 7, score = 400
            //   59                   | pop                 ecx
            //   e9????????           |                     
            //   55                   | push                ebp
            //   89e5                 | mov                 ebp, esp
            //   5d                   | pop                 ebp
            //   bf????????           |                     
            //   6a40                 | push                0x40

    condition:
        7 of them and filesize < 40960
}